/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackageRequest extends IotRequest implements
        ToCopyableBuilder<UpdatePackageRequest.Builder, UpdatePackageRequest> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageName").getter(getter(UpdatePackageRequest::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("packageName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdatePackageRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DEFAULT_VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultVersionName").getter(getter(UpdatePackageRequest::defaultVersionName))
            .setter(setter(Builder::defaultVersionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersionName").build())
            .build();

    private static final SdkField<Boolean> UNSET_DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("unsetDefaultVersion").getter(getter(UpdatePackageRequest::unsetDefaultVersion))
            .setter(setter(Builder::unsetDefaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unsetDefaultVersion").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdatePackageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD,
            DESCRIPTION_FIELD, DEFAULT_VERSION_NAME_FIELD, UNSET_DEFAULT_VERSION_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String packageName;

    private final String description;

    private final String defaultVersionName;

    private final Boolean unsetDefaultVersion;

    private final String clientToken;

    private UpdatePackageRequest(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.description = builder.description;
        this.defaultVersionName = builder.defaultVersionName;
        this.unsetDefaultVersion = builder.unsetDefaultVersion;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the target software package.
     * </p>
     * 
     * @return The name of the target software package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The package description.
     * </p>
     * 
     * @return The package description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the default package version.
     * </p>
     * <p>
     * <b>Note:</b> You cannot name a <code>defaultVersion</code> and set <code>unsetDefaultVersion</code> equal to
     * <code>true</code> at the same time.
     * </p>
     * 
     * @return The name of the default package version.</p>
     *         <p>
     *         <b>Note:</b> You cannot name a <code>defaultVersion</code> and set <code>unsetDefaultVersion</code> equal
     *         to <code>true</code> at the same time.
     */
    public final String defaultVersionName() {
        return defaultVersionName;
    }

    /**
     * <p>
     * Indicates whether you want to remove the named default package version from the software package. Set as
     * <code>true</code> to remove the default package version.
     * </p>
     * <p>
     * <b>Note:</b> You cannot name a <code>defaultVersion</code> and set <code>unsetDefaultVersion</code> equal to
     * <code>true</code> at the same time.
     * </p>
     * 
     * @return Indicates whether you want to remove the named default package version from the software package. Set as
     *         <code>true</code> to remove the default package version. </p>
     *         <p>
     *         <b>Note:</b> You cannot name a <code>defaultVersion</code> and set <code>unsetDefaultVersion</code> equal
     *         to <code>true</code> at the same time.
     */
    public final Boolean unsetDefaultVersion() {
        return unsetDefaultVersion;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionName());
        hashCode = 31 * hashCode + Objects.hashCode(unsetDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageRequest)) {
            return false;
        }
        UpdatePackageRequest other = (UpdatePackageRequest) obj;
        return Objects.equals(packageName(), other.packageName()) && Objects.equals(description(), other.description())
                && Objects.equals(defaultVersionName(), other.defaultVersionName())
                && Objects.equals(unsetDefaultVersion(), other.unsetDefaultVersion())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePackageRequest").add("PackageName", packageName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DefaultVersionName", defaultVersionName()).add("UnsetDefaultVersion", unsetDefaultVersion())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "defaultVersionName":
            return Optional.ofNullable(clazz.cast(defaultVersionName()));
        case "unsetDefaultVersion":
            return Optional.ofNullable(clazz.cast(unsetDefaultVersion()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("defaultVersionName", DEFAULT_VERSION_NAME_FIELD);
        map.put("unsetDefaultVersion", UNSET_DEFAULT_VERSION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageRequest, T> g) {
        return obj -> g.apply((UpdatePackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePackageRequest> {
        /**
         * <p>
         * The name of the target software package.
         * </p>
         * 
         * @param packageName
         *        The name of the target software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The package description.
         * </p>
         * 
         * @param description
         *        The package description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the default package version.
         * </p>
         * <p>
         * <b>Note:</b> You cannot name a <code>defaultVersion</code> and set <code>unsetDefaultVersion</code> equal to
         * <code>true</code> at the same time.
         * </p>
         * 
         * @param defaultVersionName
         *        The name of the default package version.</p>
         *        <p>
         *        <b>Note:</b> You cannot name a <code>defaultVersion</code> and set <code>unsetDefaultVersion</code>
         *        equal to <code>true</code> at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionName(String defaultVersionName);

        /**
         * <p>
         * Indicates whether you want to remove the named default package version from the software package. Set as
         * <code>true</code> to remove the default package version.
         * </p>
         * <p>
         * <b>Note:</b> You cannot name a <code>defaultVersion</code> and set <code>unsetDefaultVersion</code> equal to
         * <code>true</code> at the same time.
         * </p>
         * 
         * @param unsetDefaultVersion
         *        Indicates whether you want to remove the named default package version from the software package. Set
         *        as <code>true</code> to remove the default package version. </p>
         *        <p>
         *        <b>Note:</b> You cannot name a <code>defaultVersion</code> and set <code>unsetDefaultVersion</code>
         *        equal to <code>true</code> at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsetDefaultVersion(Boolean unsetDefaultVersion);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String packageName;

        private String description;

        private String defaultVersionName;

        private Boolean unsetDefaultVersion;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageRequest model) {
            super(model);
            packageName(model.packageName);
            description(model.description);
            defaultVersionName(model.defaultVersionName);
            unsetDefaultVersion(model.unsetDefaultVersion);
            clientToken(model.clientToken);
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultVersionName() {
            return defaultVersionName;
        }

        public final void setDefaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
        }

        @Override
        public final Builder defaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
            return this;
        }

        public final Boolean getUnsetDefaultVersion() {
            return unsetDefaultVersion;
        }

        public final void setUnsetDefaultVersion(Boolean unsetDefaultVersion) {
            this.unsetDefaultVersion = unsetDefaultVersion;
        }

        @Override
        public final Builder unsetDefaultVersion(Boolean unsetDefaultVersion) {
            this.unsetDefaultVersion = unsetDefaultVersion;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageRequest build() {
            return new UpdatePackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
