/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainConfigurationRequest extends IotRequest implements
        ToCopyableBuilder<UpdateDomainConfigurationRequest.Builder, UpdateDomainConfigurationRequest> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainConfigurationName").getter(getter(UpdateDomainConfigurationRequest::domainConfigurationName))
            .setter(setter(Builder::domainConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainConfigurationName").build())
            .build();

    private static final SdkField<AuthorizerConfig> AUTHORIZER_CONFIG_FIELD = SdkField
            .<AuthorizerConfig> builder(MarshallingType.SDK_POJO).memberName("authorizerConfig")
            .getter(getter(UpdateDomainConfigurationRequest::authorizerConfig)).setter(setter(Builder::authorizerConfig))
            .constructor(AuthorizerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfig").build()).build();

    private static final SdkField<String> DOMAIN_CONFIGURATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainConfigurationStatus")
            .getter(getter(UpdateDomainConfigurationRequest::domainConfigurationStatusAsString))
            .setter(setter(Builder::domainConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationStatus").build())
            .build();

    private static final SdkField<Boolean> REMOVE_AUTHORIZER_CONFIG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("removeAuthorizerConfig").getter(getter(UpdateDomainConfigurationRequest::removeAuthorizerConfig))
            .setter(setter(Builder::removeAuthorizerConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeAuthorizerConfig").build())
            .build();

    private static final SdkField<TlsConfig> TLS_CONFIG_FIELD = SdkField.<TlsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("tlsConfig").getter(getter(UpdateDomainConfigurationRequest::tlsConfig))
            .setter(setter(Builder::tlsConfig)).constructor(TlsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsConfig").build()).build();

    private static final SdkField<ServerCertificateConfig> SERVER_CERTIFICATE_CONFIG_FIELD = SdkField
            .<ServerCertificateConfig> builder(MarshallingType.SDK_POJO).memberName("serverCertificateConfig")
            .getter(getter(UpdateDomainConfigurationRequest::serverCertificateConfig))
            .setter(setter(Builder::serverCertificateConfig)).constructor(ServerCertificateConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificateConfig").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(UpdateDomainConfigurationRequest::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<String> APPLICATION_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationProtocol").getter(getter(UpdateDomainConfigurationRequest::applicationProtocolAsString))
            .setter(setter(Builder::applicationProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationProtocol").build())
            .build();

    private static final SdkField<ClientCertificateConfig> CLIENT_CERTIFICATE_CONFIG_FIELD = SdkField
            .<ClientCertificateConfig> builder(MarshallingType.SDK_POJO).memberName("clientCertificateConfig")
            .getter(getter(UpdateDomainConfigurationRequest::clientCertificateConfig))
            .setter(setter(Builder::clientCertificateConfig)).constructor(ClientCertificateConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOMAIN_CONFIGURATION_NAME_FIELD, AUTHORIZER_CONFIG_FIELD, DOMAIN_CONFIGURATION_STATUS_FIELD,
            REMOVE_AUTHORIZER_CONFIG_FIELD, TLS_CONFIG_FIELD, SERVER_CERTIFICATE_CONFIG_FIELD, AUTHENTICATION_TYPE_FIELD,
            APPLICATION_PROTOCOL_FIELD, CLIENT_CERTIFICATE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainConfigurationName;

    private final AuthorizerConfig authorizerConfig;

    private final String domainConfigurationStatus;

    private final Boolean removeAuthorizerConfig;

    private final TlsConfig tlsConfig;

    private final ServerCertificateConfig serverCertificateConfig;

    private final String authenticationType;

    private final String applicationProtocol;

    private final ClientCertificateConfig clientCertificateConfig;

    private UpdateDomainConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domainConfigurationName = builder.domainConfigurationName;
        this.authorizerConfig = builder.authorizerConfig;
        this.domainConfigurationStatus = builder.domainConfigurationStatus;
        this.removeAuthorizerConfig = builder.removeAuthorizerConfig;
        this.tlsConfig = builder.tlsConfig;
        this.serverCertificateConfig = builder.serverCertificateConfig;
        this.authenticationType = builder.authenticationType;
        this.applicationProtocol = builder.applicationProtocol;
        this.clientCertificateConfig = builder.clientCertificateConfig;
    }

    /**
     * <p>
     * The name of the domain configuration to be updated.
     * </p>
     * 
     * @return The name of the domain configuration to be updated.
     */
    public final String domainConfigurationName() {
        return domainConfigurationName;
    }

    /**
     * <p>
     * An object that specifies the authorization service for a domain.
     * </p>
     * 
     * @return An object that specifies the authorization service for a domain.
     */
    public final AuthorizerConfig authorizerConfig() {
        return authorizerConfig;
    }

    /**
     * <p>
     * The status to which the domain configuration should be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainConfigurationStatus} will return {@link DomainConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #domainConfigurationStatusAsString}.
     * </p>
     * 
     * @return The status to which the domain configuration should be updated.
     * @see DomainConfigurationStatus
     */
    public final DomainConfigurationStatus domainConfigurationStatus() {
        return DomainConfigurationStatus.fromValue(domainConfigurationStatus);
    }

    /**
     * <p>
     * The status to which the domain configuration should be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainConfigurationStatus} will return {@link DomainConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #domainConfigurationStatusAsString}.
     * </p>
     * 
     * @return The status to which the domain configuration should be updated.
     * @see DomainConfigurationStatus
     */
    public final String domainConfigurationStatusAsString() {
        return domainConfigurationStatus;
    }

    /**
     * <p>
     * Removes the authorization configuration from a domain.
     * </p>
     * 
     * @return Removes the authorization configuration from a domain.
     */
    public final Boolean removeAuthorizerConfig() {
        return removeAuthorizerConfig;
    }

    /**
     * <p>
     * An object that specifies the TLS configuration for a domain.
     * </p>
     * 
     * @return An object that specifies the TLS configuration for a domain.
     */
    public final TlsConfig tlsConfig() {
        return tlsConfig;
    }

    /**
     * <p>
     * The server certificate configuration.
     * </p>
     * 
     * @return The server certificate configuration.
     */
    public final ServerCertificateConfig serverCertificateConfig() {
        return serverCertificateConfig;
    }

    /**
     * <p>
     * An enumerated string that speciﬁes the authentication type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from the
     * X.509 client certificate.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom authentication and
     * authorization</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization. For more
     * information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509
     * client certificates</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users, groups, and
     * roles</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>DEFAULT </code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
     * authentication type. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication protocols</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return An enumerated string that speciﬁes the authentication type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from
     *         the X.509 client certificate.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom
     *         authentication and authorization</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
     *         certificates</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users,
     *         groups, and roles</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEFAULT </code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
     *         specify authentication type. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
     *         protocols</a>.
     *         </p>
     *         </li>
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * An enumerated string that speciﬁes the authentication type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from the
     * X.509 client certificate.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom authentication and
     * authorization</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization. For more
     * information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509
     * client certificates</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users, groups, and
     * roles</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>DEFAULT </code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
     * authentication type. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication protocols</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return An enumerated string that speciﬁes the authentication type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from
     *         the X.509 client certificate.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom
     *         authentication and authorization</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
     *         certificates</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users,
     *         groups, and roles</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEFAULT </code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
     *         specify authentication type. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
     *         protocols</a>.
     *         </p>
     *         </li>
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * An enumerated string that speciﬁes the application-layer protocol.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SECURE_MQTT</code> - MQTT over TLS.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>MQTT_WSS</code> - MQTT over WebSocket.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>HTTPS</code> - HTTP over TLS.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
     * application_layer protocol. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication protocols</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #applicationProtocol} will return {@link ApplicationProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #applicationProtocolAsString}.
     * </p>
     * 
     * @return An enumerated string that speciﬁes the application-layer protocol.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SECURE_MQTT</code> - MQTT over TLS.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MQTT_WSS</code> - MQTT over WebSocket.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HTTPS</code> - HTTP over TLS.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
     *         specify application_layer protocol. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
     *         protocols</a>.
     *         </p>
     *         </li>
     * @see ApplicationProtocol
     */
    public final ApplicationProtocol applicationProtocol() {
        return ApplicationProtocol.fromValue(applicationProtocol);
    }

    /**
     * <p>
     * An enumerated string that speciﬁes the application-layer protocol.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SECURE_MQTT</code> - MQTT over TLS.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>MQTT_WSS</code> - MQTT over WebSocket.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>HTTPS</code> - HTTP over TLS.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
     * application_layer protocol. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication protocols</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #applicationProtocol} will return {@link ApplicationProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #applicationProtocolAsString}.
     * </p>
     * 
     * @return An enumerated string that speciﬁes the application-layer protocol.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SECURE_MQTT</code> - MQTT over TLS.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MQTT_WSS</code> - MQTT over WebSocket.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HTTPS</code> - HTTP over TLS.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
     *         specify application_layer protocol. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
     *         protocols</a>.
     *         </p>
     *         </li>
     * @see ApplicationProtocol
     */
    public final String applicationProtocolAsString() {
        return applicationProtocol;
    }

    /**
     * <p>
     * An object that speciﬁes the client certificate conﬁguration for a domain.
     * </p>
     * 
     * @return An object that speciﬁes the client certificate conﬁguration for a domain.
     */
    public final ClientCertificateConfig clientCertificateConfig() {
        return clientCertificateConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(removeAuthorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(tlsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainConfigurationRequest)) {
            return false;
        }
        UpdateDomainConfigurationRequest other = (UpdateDomainConfigurationRequest) obj;
        return Objects.equals(domainConfigurationName(), other.domainConfigurationName())
                && Objects.equals(authorizerConfig(), other.authorizerConfig())
                && Objects.equals(domainConfigurationStatusAsString(), other.domainConfigurationStatusAsString())
                && Objects.equals(removeAuthorizerConfig(), other.removeAuthorizerConfig())
                && Objects.equals(tlsConfig(), other.tlsConfig())
                && Objects.equals(serverCertificateConfig(), other.serverCertificateConfig())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(applicationProtocolAsString(), other.applicationProtocolAsString())
                && Objects.equals(clientCertificateConfig(), other.clientCertificateConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainConfigurationRequest").add("DomainConfigurationName", domainConfigurationName())
                .add("AuthorizerConfig", authorizerConfig())
                .add("DomainConfigurationStatus", domainConfigurationStatusAsString())
                .add("RemoveAuthorizerConfig", removeAuthorizerConfig()).add("TlsConfig", tlsConfig())
                .add("ServerCertificateConfig", serverCertificateConfig())
                .add("AuthenticationType", authenticationTypeAsString())
                .add("ApplicationProtocol", applicationProtocolAsString())
                .add("ClientCertificateConfig", clientCertificateConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainConfigurationName":
            return Optional.ofNullable(clazz.cast(domainConfigurationName()));
        case "authorizerConfig":
            return Optional.ofNullable(clazz.cast(authorizerConfig()));
        case "domainConfigurationStatus":
            return Optional.ofNullable(clazz.cast(domainConfigurationStatusAsString()));
        case "removeAuthorizerConfig":
            return Optional.ofNullable(clazz.cast(removeAuthorizerConfig()));
        case "tlsConfig":
            return Optional.ofNullable(clazz.cast(tlsConfig()));
        case "serverCertificateConfig":
            return Optional.ofNullable(clazz.cast(serverCertificateConfig()));
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "applicationProtocol":
            return Optional.ofNullable(clazz.cast(applicationProtocolAsString()));
        case "clientCertificateConfig":
            return Optional.ofNullable(clazz.cast(clientCertificateConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainConfigurationName", DOMAIN_CONFIGURATION_NAME_FIELD);
        map.put("authorizerConfig", AUTHORIZER_CONFIG_FIELD);
        map.put("domainConfigurationStatus", DOMAIN_CONFIGURATION_STATUS_FIELD);
        map.put("removeAuthorizerConfig", REMOVE_AUTHORIZER_CONFIG_FIELD);
        map.put("tlsConfig", TLS_CONFIG_FIELD);
        map.put("serverCertificateConfig", SERVER_CERTIFICATE_CONFIG_FIELD);
        map.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("applicationProtocol", APPLICATION_PROTOCOL_FIELD);
        map.put("clientCertificateConfig", CLIENT_CERTIFICATE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateDomainConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainConfigurationRequest> {
        /**
         * <p>
         * The name of the domain configuration to be updated.
         * </p>
         * 
         * @param domainConfigurationName
         *        The name of the domain configuration to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfigurationName(String domainConfigurationName);

        /**
         * <p>
         * An object that specifies the authorization service for a domain.
         * </p>
         * 
         * @param authorizerConfig
         *        An object that specifies the authorization service for a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerConfig(AuthorizerConfig authorizerConfig);

        /**
         * <p>
         * An object that specifies the authorization service for a domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizerConfig.Builder} avoiding the
         * need to create one manually via {@link AuthorizerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #authorizerConfig(AuthorizerConfig)}.
         * 
         * @param authorizerConfig
         *        a consumer that will call methods on {@link AuthorizerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizerConfig(AuthorizerConfig)
         */
        default Builder authorizerConfig(Consumer<AuthorizerConfig.Builder> authorizerConfig) {
            return authorizerConfig(AuthorizerConfig.builder().applyMutation(authorizerConfig).build());
        }

        /**
         * <p>
         * The status to which the domain configuration should be updated.
         * </p>
         * 
         * @param domainConfigurationStatus
         *        The status to which the domain configuration should be updated.
         * @see DomainConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainConfigurationStatus
         */
        Builder domainConfigurationStatus(String domainConfigurationStatus);

        /**
         * <p>
         * The status to which the domain configuration should be updated.
         * </p>
         * 
         * @param domainConfigurationStatus
         *        The status to which the domain configuration should be updated.
         * @see DomainConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainConfigurationStatus
         */
        Builder domainConfigurationStatus(DomainConfigurationStatus domainConfigurationStatus);

        /**
         * <p>
         * Removes the authorization configuration from a domain.
         * </p>
         * 
         * @param removeAuthorizerConfig
         *        Removes the authorization configuration from a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAuthorizerConfig(Boolean removeAuthorizerConfig);

        /**
         * <p>
         * An object that specifies the TLS configuration for a domain.
         * </p>
         * 
         * @param tlsConfig
         *        An object that specifies the TLS configuration for a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsConfig(TlsConfig tlsConfig);

        /**
         * <p>
         * An object that specifies the TLS configuration for a domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link TlsConfig.Builder} avoiding the need to
         * create one manually via {@link TlsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TlsConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #tlsConfig(TlsConfig)}.
         * 
         * @param tlsConfig
         *        a consumer that will call methods on {@link TlsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsConfig(TlsConfig)
         */
        default Builder tlsConfig(Consumer<TlsConfig.Builder> tlsConfig) {
            return tlsConfig(TlsConfig.builder().applyMutation(tlsConfig).build());
        }

        /**
         * <p>
         * The server certificate configuration.
         * </p>
         * 
         * @param serverCertificateConfig
         *        The server certificate configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateConfig(ServerCertificateConfig serverCertificateConfig);

        /**
         * <p>
         * The server certificate configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerCertificateConfig.Builder} avoiding
         * the need to create one manually via {@link ServerCertificateConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerCertificateConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #serverCertificateConfig(ServerCertificateConfig)}.
         * 
         * @param serverCertificateConfig
         *        a consumer that will call methods on {@link ServerCertificateConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverCertificateConfig(ServerCertificateConfig)
         */
        default Builder serverCertificateConfig(Consumer<ServerCertificateConfig.Builder> serverCertificateConfig) {
            return serverCertificateConfig(ServerCertificateConfig.builder().applyMutation(serverCertificateConfig).build());
        }

        /**
         * <p>
         * An enumerated string that speciﬁes the authentication type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from the
         * X.509 client certificate.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom authentication
         * and authorization</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
         * certificates</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users, groups,
         * and roles</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>DEFAULT </code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
         * specify authentication type. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         * protocols</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param authenticationType
         *        An enumerated string that speciﬁes the authentication type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details
         *        from the X.509 client certificate.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom
         *        authentication and authorization</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
         *        certificates</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users,
         *        groups, and roles</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEFAULT </code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
         *        specify authentication type. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         *        protocols</a>.
         *        </p>
         *        </li>
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * An enumerated string that speciﬁes the authentication type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details from the
         * X.509 client certificate.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom authentication
         * and authorization</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
         * certificates</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users, groups,
         * and roles</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>DEFAULT </code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
         * specify authentication type. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         * protocols</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param authenticationType
         *        An enumerated string that speciﬁes the authentication type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CUSTOM_AUTH_X509</code> - Use custom authentication and authorization with additional details
         *        from the X.509 client certificate.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CUSTOM_AUTH</code> - Use custom authentication and authorization. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">Custom
         *        authentication and authorization</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_X509</code> - Use X.509 client certificates without custom authentication and authorization.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html">X.509 client
         *        certificates</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_SIGV4</code> - Use Amazon Web Services Signature Version 4. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html">IAM users,
         *        groups, and roles</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEFAULT </code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
         *        specify authentication type. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         *        protocols</a>.
         *        </p>
         *        </li>
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * An enumerated string that speciﬁes the application-layer protocol.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SECURE_MQTT</code> - MQTT over TLS.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>MQTT_WSS</code> - MQTT over WebSocket.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>HTTPS</code> - HTTP over TLS.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
         * application_layer protocol. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         * protocols</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param applicationProtocol
         *        An enumerated string that speciﬁes the application-layer protocol.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SECURE_MQTT</code> - MQTT over TLS.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MQTT_WSS</code> - MQTT over WebSocket.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HTTPS</code> - HTTP over TLS.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
         *        specify application_layer protocol. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         *        protocols</a>.
         *        </p>
         *        </li>
         * @see ApplicationProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationProtocol
         */
        Builder applicationProtocol(String applicationProtocol);

        /**
         * <p>
         * An enumerated string that speciﬁes the application-layer protocol.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SECURE_MQTT</code> - MQTT over TLS.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>MQTT_WSS</code> - MQTT over WebSocket.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>HTTPS</code> - HTTP over TLS.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify
         * application_layer protocol. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         * protocols</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param applicationProtocol
         *        An enumerated string that speciﬁes the application-layer protocol.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SECURE_MQTT</code> - MQTT over TLS.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MQTT_WSS</code> - MQTT over WebSocket.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HTTPS</code> - HTTP over TLS.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEFAULT</code> - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to
         *        specify application_layer protocol. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html">Device communication
         *        protocols</a>.
         *        </p>
         *        </li>
         * @see ApplicationProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationProtocol
         */
        Builder applicationProtocol(ApplicationProtocol applicationProtocol);

        /**
         * <p>
         * An object that speciﬁes the client certificate conﬁguration for a domain.
         * </p>
         * 
         * @param clientCertificateConfig
         *        An object that speciﬁes the client certificate conﬁguration for a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateConfig(ClientCertificateConfig clientCertificateConfig);

        /**
         * <p>
         * An object that speciﬁes the client certificate conﬁguration for a domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientCertificateConfig.Builder} avoiding
         * the need to create one manually via {@link ClientCertificateConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientCertificateConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #clientCertificateConfig(ClientCertificateConfig)}.
         * 
         * @param clientCertificateConfig
         *        a consumer that will call methods on {@link ClientCertificateConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientCertificateConfig(ClientCertificateConfig)
         */
        default Builder clientCertificateConfig(Consumer<ClientCertificateConfig.Builder> clientCertificateConfig) {
            return clientCertificateConfig(ClientCertificateConfig.builder().applyMutation(clientCertificateConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String domainConfigurationName;

        private AuthorizerConfig authorizerConfig;

        private String domainConfigurationStatus;

        private Boolean removeAuthorizerConfig;

        private TlsConfig tlsConfig;

        private ServerCertificateConfig serverCertificateConfig;

        private String authenticationType;

        private String applicationProtocol;

        private ClientCertificateConfig clientCertificateConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainConfigurationRequest model) {
            super(model);
            domainConfigurationName(model.domainConfigurationName);
            authorizerConfig(model.authorizerConfig);
            domainConfigurationStatus(model.domainConfigurationStatus);
            removeAuthorizerConfig(model.removeAuthorizerConfig);
            tlsConfig(model.tlsConfig);
            serverCertificateConfig(model.serverCertificateConfig);
            authenticationType(model.authenticationType);
            applicationProtocol(model.applicationProtocol);
            clientCertificateConfig(model.clientCertificateConfig);
        }

        public final String getDomainConfigurationName() {
            return domainConfigurationName;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        @Override
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final AuthorizerConfig.Builder getAuthorizerConfig() {
            return authorizerConfig != null ? authorizerConfig.toBuilder() : null;
        }

        public final void setAuthorizerConfig(AuthorizerConfig.BuilderImpl authorizerConfig) {
            this.authorizerConfig = authorizerConfig != null ? authorizerConfig.build() : null;
        }

        @Override
        public final Builder authorizerConfig(AuthorizerConfig authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        public final String getDomainConfigurationStatus() {
            return domainConfigurationStatus;
        }

        public final void setDomainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
        }

        @Override
        public final Builder domainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
            return this;
        }

        @Override
        public final Builder domainConfigurationStatus(DomainConfigurationStatus domainConfigurationStatus) {
            this.domainConfigurationStatus(domainConfigurationStatus == null ? null : domainConfigurationStatus.toString());
            return this;
        }

        public final Boolean getRemoveAuthorizerConfig() {
            return removeAuthorizerConfig;
        }

        public final void setRemoveAuthorizerConfig(Boolean removeAuthorizerConfig) {
            this.removeAuthorizerConfig = removeAuthorizerConfig;
        }

        @Override
        public final Builder removeAuthorizerConfig(Boolean removeAuthorizerConfig) {
            this.removeAuthorizerConfig = removeAuthorizerConfig;
            return this;
        }

        public final TlsConfig.Builder getTlsConfig() {
            return tlsConfig != null ? tlsConfig.toBuilder() : null;
        }

        public final void setTlsConfig(TlsConfig.BuilderImpl tlsConfig) {
            this.tlsConfig = tlsConfig != null ? tlsConfig.build() : null;
        }

        @Override
        public final Builder tlsConfig(TlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public final ServerCertificateConfig.Builder getServerCertificateConfig() {
            return serverCertificateConfig != null ? serverCertificateConfig.toBuilder() : null;
        }

        public final void setServerCertificateConfig(ServerCertificateConfig.BuilderImpl serverCertificateConfig) {
            this.serverCertificateConfig = serverCertificateConfig != null ? serverCertificateConfig.build() : null;
        }

        @Override
        public final Builder serverCertificateConfig(ServerCertificateConfig serverCertificateConfig) {
            this.serverCertificateConfig = serverCertificateConfig;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getApplicationProtocol() {
            return applicationProtocol;
        }

        public final void setApplicationProtocol(String applicationProtocol) {
            this.applicationProtocol = applicationProtocol;
        }

        @Override
        public final Builder applicationProtocol(String applicationProtocol) {
            this.applicationProtocol = applicationProtocol;
            return this;
        }

        @Override
        public final Builder applicationProtocol(ApplicationProtocol applicationProtocol) {
            this.applicationProtocol(applicationProtocol == null ? null : applicationProtocol.toString());
            return this;
        }

        public final ClientCertificateConfig.Builder getClientCertificateConfig() {
            return clientCertificateConfig != null ? clientCertificateConfig.toBuilder() : null;
        }

        public final void setClientCertificateConfig(ClientCertificateConfig.BuilderImpl clientCertificateConfig) {
            this.clientCertificateConfig = clientCertificateConfig != null ? clientCertificateConfig.build() : null;
        }

        @Override
        public final Builder clientCertificateConfig(ClientCertificateConfig clientCertificateConfig) {
            this.clientCertificateConfig = clientCertificateConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainConfigurationRequest build() {
            return new UpdateDomainConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
