/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRuleListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicRuleListItem.Builder, TopicRuleListItem> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleArn").getter(getter(TopicRuleListItem::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleArn").build()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleName").getter(getter(TopicRuleListItem::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()).build();

    private static final SdkField<String> TOPIC_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("topicPattern").getter(getter(TopicRuleListItem::topicPattern)).setter(setter(Builder::topicPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPattern").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(TopicRuleListItem::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Boolean> RULE_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ruleDisabled").getter(getter(TopicRuleListItem::ruleDisabled)).setter(setter(Builder::ruleDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDisabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD,
            RULE_NAME_FIELD, TOPIC_PATTERN_FIELD, CREATED_AT_FIELD, RULE_DISABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ruleArn;

    private final String ruleName;

    private final String topicPattern;

    private final Instant createdAt;

    private final Boolean ruleDisabled;

    private TopicRuleListItem(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.ruleName = builder.ruleName;
        this.topicPattern = builder.topicPattern;
        this.createdAt = builder.createdAt;
        this.ruleDisabled = builder.ruleDisabled;
    }

    /**
     * <p>
     * The rule ARN.
     * </p>
     * 
     * @return The rule ARN.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The pattern for the topic names that apply.
     * </p>
     * 
     * @return The pattern for the topic names that apply.
     */
    public final String topicPattern() {
        return topicPattern;
    }

    /**
     * <p>
     * The date and time the rule was created.
     * </p>
     * 
     * @return The date and time the rule was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies whether the rule is disabled.
     * </p>
     * 
     * @return Specifies whether the rule is disabled.
     */
    public final Boolean ruleDisabled() {
        return ruleDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(topicPattern());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(ruleDisabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleListItem)) {
            return false;
        }
        TopicRuleListItem other = (TopicRuleListItem) obj;
        return Objects.equals(ruleArn(), other.ruleArn()) && Objects.equals(ruleName(), other.ruleName())
                && Objects.equals(topicPattern(), other.topicPattern()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(ruleDisabled(), other.ruleDisabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicRuleListItem").add("RuleArn", ruleArn()).add("RuleName", ruleName())
                .add("TopicPattern", topicPattern()).add("CreatedAt", createdAt()).add("RuleDisabled", ruleDisabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "topicPattern":
            return Optional.ofNullable(clazz.cast(topicPattern()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ruleDisabled":
            return Optional.ofNullable(clazz.cast(ruleDisabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ruleArn", RULE_ARN_FIELD);
        map.put("ruleName", RULE_NAME_FIELD);
        map.put("topicPattern", TOPIC_PATTERN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("ruleDisabled", RULE_DISABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicRuleListItem, T> g) {
        return obj -> g.apply((TopicRuleListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRuleListItem> {
        /**
         * <p>
         * The rule ARN.
         * </p>
         * 
         * @param ruleArn
         *        The rule ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The pattern for the topic names that apply.
         * </p>
         * 
         * @param topicPattern
         *        The pattern for the topic names that apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPattern(String topicPattern);

        /**
         * <p>
         * The date and time the rule was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies whether the rule is disabled.
         * </p>
         * 
         * @param ruleDisabled
         *        Specifies whether the rule is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDisabled(Boolean ruleDisabled);
    }

    static final class BuilderImpl implements Builder {
        private String ruleArn;

        private String ruleName;

        private String topicPattern;

        private Instant createdAt;

        private Boolean ruleDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleListItem model) {
            ruleArn(model.ruleArn);
            ruleName(model.ruleName);
            topicPattern(model.topicPattern);
            createdAt(model.createdAt);
            ruleDisabled(model.ruleDisabled);
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getTopicPattern() {
            return topicPattern;
        }

        public final void setTopicPattern(String topicPattern) {
            this.topicPattern = topicPattern;
        }

        @Override
        public final Builder topicPattern(String topicPattern) {
            this.topicPattern = topicPattern;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getRuleDisabled() {
            return ruleDisabled;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        @Override
        public TopicRuleListItem build() {
            return new TopicRuleListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
