/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provide additional context about the status of a command execution using a reason code and description.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatusReason implements SdkPojo, Serializable, ToCopyableBuilder<StatusReason.Builder, StatusReason> {
    private static final SdkField<String> REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reasonCode").getter(getter(StatusReason::reasonCode)).setter(setter(Builder::reasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonCode").build()).build();

    private static final SdkField<String> REASON_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reasonDescription").getter(getter(StatusReason::reasonDescription))
            .setter(setter(Builder::reasonDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_CODE_FIELD,
            REASON_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reasonCode;

    private final String reasonDescription;

    private StatusReason(BuilderImpl builder) {
        this.reasonCode = builder.reasonCode;
        this.reasonDescription = builder.reasonDescription;
    }

    /**
     * <p>
     * A code that provides additional context for the command execution status.
     * </p>
     * 
     * @return A code that provides additional context for the command execution status.
     */
    public final String reasonCode() {
        return reasonCode;
    }

    /**
     * <p>
     * A literal string for devices to optionally provide additional information about the reason code for a command
     * execution status.
     * </p>
     * 
     * @return A literal string for devices to optionally provide additional information about the reason code for a
     *         command execution status.
     */
    public final String reasonDescription() {
        return reasonDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reasonCode());
        hashCode = 31 * hashCode + Objects.hashCode(reasonDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusReason)) {
            return false;
        }
        StatusReason other = (StatusReason) obj;
        return Objects.equals(reasonCode(), other.reasonCode()) && Objects.equals(reasonDescription(), other.reasonDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatusReason").add("ReasonCode", reasonCode()).add("ReasonDescription", reasonDescription())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reasonCode":
            return Optional.ofNullable(clazz.cast(reasonCode()));
        case "reasonDescription":
            return Optional.ofNullable(clazz.cast(reasonDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reasonCode", REASON_CODE_FIELD);
        map.put("reasonDescription", REASON_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatusReason, T> g) {
        return obj -> g.apply((StatusReason) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatusReason> {
        /**
         * <p>
         * A code that provides additional context for the command execution status.
         * </p>
         * 
         * @param reasonCode
         *        A code that provides additional context for the command execution status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCode(String reasonCode);

        /**
         * <p>
         * A literal string for devices to optionally provide additional information about the reason code for a command
         * execution status.
         * </p>
         * 
         * @param reasonDescription
         *        A literal string for devices to optionally provide additional information about the reason code for a
         *        command execution status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonDescription(String reasonDescription);
    }

    static final class BuilderImpl implements Builder {
        private String reasonCode;

        private String reasonDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusReason model) {
            reasonCode(model.reasonCode);
            reasonDescription(model.reasonDescription);
        }

        public final String getReasonCode() {
            return reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public final String getReasonDescription() {
            return reasonDescription;
        }

        public final void setReasonDescription(String reasonDescription) {
            this.reasonDescription = reasonDescription;
        }

        @Override
        public final Builder reasonDescription(String reasonDescription) {
            this.reasonDescription = reasonDescription;
            return this;
        }

        @Override
        public StatusReason build() {
            return new StatusReason(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
