/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input to the RegisterCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterCertificateRequest extends IotRequest implements
        ToCopyableBuilder<RegisterCertificateRequest.Builder, RegisterCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificatePem").getter(getter(RegisterCertificateRequest::certificatePem))
            .setter(setter(Builder::certificatePem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()).build();

    private static final SdkField<String> CA_CERTIFICATE_PEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caCertificatePem").getter(getter(RegisterCertificateRequest::caCertificatePem))
            .setter(setter(Builder::caCertificatePem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificatePem").build()).build();

    private static final SdkField<Boolean> SET_AS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("setAsActive").getter(getter(RegisterCertificateRequest::setAsActive))
            .setter(setter(Builder::setAsActive))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("setAsActive").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RegisterCertificateRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_PEM_FIELD,
            CA_CERTIFICATE_PEM_FIELD, SET_AS_ACTIVE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String certificatePem;

    private final String caCertificatePem;

    private final Boolean setAsActive;

    private final String status;

    private RegisterCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificatePem = builder.certificatePem;
        this.caCertificatePem = builder.caCertificatePem;
        this.setAsActive = builder.setAsActive;
        this.status = builder.status;
    }

    /**
     * <p>
     * The certificate data, in PEM format.
     * </p>
     * 
     * @return The certificate data, in PEM format.
     */
    public final String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The CA certificate used to sign the device certificate being registered.
     * </p>
     * 
     * @return The CA certificate used to sign the device certificate being registered.
     */
    public final String caCertificatePem() {
        return caCertificatePem;
    }

    /**
     * <p>
     * A boolean value that specifies if the certificate is set to active.
     * </p>
     * <p>
     * Valid values: <code>ACTIVE | INACTIVE</code>
     * </p>
     * 
     * @return A boolean value that specifies if the certificate is set to active.</p>
     *         <p>
     *         Valid values: <code>ACTIVE | INACTIVE</code>
     * @deprecated
     */
    @Deprecated
    public final Boolean setAsActive() {
        return setAsActive;
    }

    /**
     * <p>
     * The status of the register certificate request. Valid values that you can use include <code>ACTIVE</code>,
     * <code>INACTIVE</code>, and <code>REVOKED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the register certificate request. Valid values that you can use include <code>ACTIVE</code>
     *         , <code>INACTIVE</code>, and <code>REVOKED</code>.
     * @see CertificateStatus
     */
    public final CertificateStatus status() {
        return CertificateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the register certificate request. Valid values that you can use include <code>ACTIVE</code>,
     * <code>INACTIVE</code>, and <code>REVOKED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the register certificate request. Valid values that you can use include <code>ACTIVE</code>
     *         , <code>INACTIVE</code>, and <code>REVOKED</code>.
     * @see CertificateStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(setAsActive());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCertificateRequest)) {
            return false;
        }
        RegisterCertificateRequest other = (RegisterCertificateRequest) obj;
        return Objects.equals(certificatePem(), other.certificatePem())
                && Objects.equals(caCertificatePem(), other.caCertificatePem())
                && Objects.equals(setAsActive(), other.setAsActive()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterCertificateRequest").add("CertificatePem", certificatePem())
                .add("CaCertificatePem", caCertificatePem()).add("SetAsActive", setAsActive()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificatePem":
            return Optional.ofNullable(clazz.cast(certificatePem()));
        case "caCertificatePem":
            return Optional.ofNullable(clazz.cast(caCertificatePem()));
        case "setAsActive":
            return Optional.ofNullable(clazz.cast(setAsActive()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificatePem", CERTIFICATE_PEM_FIELD);
        map.put("caCertificatePem", CA_CERTIFICATE_PEM_FIELD);
        map.put("setAsActive", SET_AS_ACTIVE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterCertificateRequest, T> g) {
        return obj -> g.apply((RegisterCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterCertificateRequest> {
        /**
         * <p>
         * The certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The CA certificate used to sign the device certificate being registered.
         * </p>
         * 
         * @param caCertificatePem
         *        The CA certificate used to sign the device certificate being registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificatePem(String caCertificatePem);

        /**
         * <p>
         * A boolean value that specifies if the certificate is set to active.
         * </p>
         * <p>
         * Valid values: <code>ACTIVE | INACTIVE</code>
         * </p>
         * 
         * @param setAsActive
         *        A boolean value that specifies if the certificate is set to active.</p>
         *        <p>
         *        Valid values: <code>ACTIVE | INACTIVE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder setAsActive(Boolean setAsActive);

        /**
         * <p>
         * The status of the register certificate request. Valid values that you can use include <code>ACTIVE</code>,
         * <code>INACTIVE</code>, and <code>REVOKED</code>.
         * </p>
         * 
         * @param status
         *        The status of the register certificate request. Valid values that you can use include
         *        <code>ACTIVE</code>, <code>INACTIVE</code>, and <code>REVOKED</code>.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the register certificate request. Valid values that you can use include <code>ACTIVE</code>,
         * <code>INACTIVE</code>, and <code>REVOKED</code>.
         * </p>
         * 
         * @param status
         *        The status of the register certificate request. Valid values that you can use include
         *        <code>ACTIVE</code>, <code>INACTIVE</code>, and <code>REVOKED</code>.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(CertificateStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String certificatePem;

        private String caCertificatePem;

        private Boolean setAsActive;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCertificateRequest model) {
            super(model);
            certificatePem(model.certificatePem);
            caCertificatePem(model.caCertificatePem);
            setAsActive(model.setAsActive);
            status(model.status);
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final String getCaCertificatePem() {
            return caCertificatePem;
        }

        public final void setCaCertificatePem(String caCertificatePem) {
            this.caCertificatePem = caCertificatePem;
        }

        @Override
        public final Builder caCertificatePem(String caCertificatePem) {
            this.caCertificatePem = caCertificatePem;
            return this;
        }

        @Deprecated
        public final Boolean getSetAsActive() {
            return setAsActive;
        }

        @Deprecated
        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterCertificateRequest build() {
            return new RegisterCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
