/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogTargetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LogTargetConfiguration.Builder, LogTargetConfiguration> {
    private static final SdkField<LogTarget> LOG_TARGET_FIELD = SdkField.<LogTarget> builder(MarshallingType.SDK_POJO)
            .memberName("logTarget").getter(getter(LogTargetConfiguration::logTarget)).setter(setter(Builder::logTarget))
            .constructor(LogTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logTarget").build()).build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logLevel").getter(getter(LogTargetConfiguration::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TARGET_FIELD,
            LOG_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LogTarget logTarget;

    private final String logLevel;

    private LogTargetConfiguration(BuilderImpl builder) {
        this.logTarget = builder.logTarget;
        this.logLevel = builder.logLevel;
    }

    /**
     * <p>
     * A log target
     * </p>
     * 
     * @return A log target
     */
    public final LogTarget logTarget() {
        return logTarget;
    }

    /**
     * <p>
     * The logging level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The logging level.
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * The logging level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The logging level.
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logTarget());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogTargetConfiguration)) {
            return false;
        }
        LogTargetConfiguration other = (LogTargetConfiguration) obj;
        return Objects.equals(logTarget(), other.logTarget()) && Objects.equals(logLevelAsString(), other.logLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogTargetConfiguration").add("LogTarget", logTarget()).add("LogLevel", logLevelAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logTarget":
            return Optional.ofNullable(clazz.cast(logTarget()));
        case "logLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logTarget", LOG_TARGET_FIELD);
        map.put("logLevel", LOG_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogTargetConfiguration, T> g) {
        return obj -> g.apply((LogTargetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogTargetConfiguration> {
        /**
         * <p>
         * A log target
         * </p>
         * 
         * @param logTarget
         *        A log target
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTarget(LogTarget logTarget);

        /**
         * <p>
         * A log target
         * </p>
         * This is a convenience method that creates an instance of the {@link LogTarget.Builder} avoiding the need to
         * create one manually via {@link LogTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogTarget.Builder#build()} is called immediately and its result
         * is passed to {@link #logTarget(LogTarget)}.
         * 
         * @param logTarget
         *        a consumer that will call methods on {@link LogTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logTarget(LogTarget)
         */
        default Builder logTarget(Consumer<LogTarget.Builder> logTarget) {
            return logTarget(LogTarget.builder().applyMutation(logTarget).build());
        }

        /**
         * <p>
         * The logging level.
         * </p>
         * 
         * @param logLevel
         *        The logging level.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * The logging level.
         * </p>
         * 
         * @param logLevel
         *        The logging level.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);
    }

    static final class BuilderImpl implements Builder {
        private LogTarget logTarget;

        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(LogTargetConfiguration model) {
            logTarget(model.logTarget);
            logLevel(model.logLevel);
        }

        public final LogTarget.Builder getLogTarget() {
            return logTarget != null ? logTarget.toBuilder() : null;
        }

        public final void setLogTarget(LogTarget.BuilderImpl logTarget) {
            this.logTarget = logTarget != null ? logTarget.build() : null;
        }

        @Override
        public final Builder logTarget(LogTarget logTarget) {
            this.logTarget = logTarget;
            return this;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        @Override
        public LogTargetConfiguration build() {
            return new LogTargetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
