/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRoleAliasesResponse extends IotResponse implements
        ToCopyableBuilder<ListRoleAliasesResponse.Builder, ListRoleAliasesResponse> {
    private static final SdkField<List<String>> ROLE_ALIASES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("roleAliases")
            .getter(getter(ListRoleAliasesResponse::roleAliases))
            .setter(setter(Builder::roleAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleAliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextMarker").getter(getter(ListRoleAliasesResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ALIASES_FIELD,
            NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> roleAliases;

    private final String nextMarker;

    private ListRoleAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.roleAliases = builder.roleAliases;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoleAliases property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoleAliases() {
        return roleAliases != null && !(roleAliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The role aliases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoleAliases} method.
     * </p>
     * 
     * @return The role aliases.
     */
    public final List<String> roleAliases() {
        return roleAliases;
    }

    /**
     * <p>
     * A marker used to get the next set of results.
     * </p>
     * 
     * @return A marker used to get the next set of results.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRoleAliases() ? roleAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoleAliasesResponse)) {
            return false;
        }
        ListRoleAliasesResponse other = (ListRoleAliasesResponse) obj;
        return hasRoleAliases() == other.hasRoleAliases() && Objects.equals(roleAliases(), other.roleAliases())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRoleAliasesResponse").add("RoleAliases", hasRoleAliases() ? roleAliases() : null)
                .add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleAliases":
            return Optional.ofNullable(clazz.cast(roleAliases()));
        case "nextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleAliases", ROLE_ALIASES_FIELD);
        map.put("nextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRoleAliasesResponse, T> g) {
        return obj -> g.apply((ListRoleAliasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRoleAliasesResponse> {
        /**
         * <p>
         * The role aliases.
         * </p>
         * 
         * @param roleAliases
         *        The role aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAliases(Collection<String> roleAliases);

        /**
         * <p>
         * The role aliases.
         * </p>
         * 
         * @param roleAliases
         *        The role aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAliases(String... roleAliases);

        /**
         * <p>
         * A marker used to get the next set of results.
         * </p>
         * 
         * @param nextMarker
         *        A marker used to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<String> roleAliases = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoleAliasesResponse model) {
            super(model);
            roleAliases(model.roleAliases);
            nextMarker(model.nextMarker);
        }

        public final Collection<String> getRoleAliases() {
            if (roleAliases instanceof SdkAutoConstructList) {
                return null;
            }
            return roleAliases;
        }

        public final void setRoleAliases(Collection<String> roleAliases) {
            this.roleAliases = RoleAliasesCopier.copy(roleAliases);
        }

        @Override
        public final Builder roleAliases(Collection<String> roleAliases) {
            this.roleAliases = RoleAliasesCopier.copy(roleAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleAliases(String... roleAliases) {
            roleAliases(Arrays.asList(roleAliases));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListRoleAliasesResponse build() {
            return new ListRoleAliasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
