/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobDocumentRequest extends IotRequest implements
        ToCopyableBuilder<GetJobDocumentRequest.Builder, GetJobDocumentRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(GetJobDocumentRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<Boolean> BEFORE_SUBSTITUTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("beforeSubstitution").getter(getter(GetJobDocumentRequest::beforeSubstitution))
            .setter(setter(Builder::beforeSubstitution))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("beforeSubstitution").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            BEFORE_SUBSTITUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobId;

    private final Boolean beforeSubstitution;

    private GetJobDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.beforeSubstitution = builder.beforeSubstitution;
    }

    /**
     * <p>
     * The unique identifier you assigned to this job when it was created.
     * </p>
     * 
     * @return The unique identifier you assigned to this job when it was created.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * Provides a view of the job document before and after the substitution parameters have been resolved with their
     * exact values.
     * </p>
     * 
     * @return Provides a view of the job document before and after the substitution parameters have been resolved with
     *         their exact values.
     */
    public final Boolean beforeSubstitution() {
        return beforeSubstitution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(beforeSubstitution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobDocumentRequest)) {
            return false;
        }
        GetJobDocumentRequest other = (GetJobDocumentRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(beforeSubstitution(), other.beforeSubstitution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobDocumentRequest").add("JobId", jobId()).add("BeforeSubstitution", beforeSubstitution())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "beforeSubstitution":
            return Optional.ofNullable(clazz.cast(beforeSubstitution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("beforeSubstitution", BEFORE_SUBSTITUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJobDocumentRequest, T> g) {
        return obj -> g.apply((GetJobDocumentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetJobDocumentRequest> {
        /**
         * <p>
         * The unique identifier you assigned to this job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to this job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * Provides a view of the job document before and after the substitution parameters have been resolved with
         * their exact values.
         * </p>
         * 
         * @param beforeSubstitution
         *        Provides a view of the job document before and after the substitution parameters have been resolved
         *        with their exact values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeSubstitution(Boolean beforeSubstitution);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String jobId;

        private Boolean beforeSubstitution;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobDocumentRequest model) {
            super(model);
            jobId(model.jobId);
            beforeSubstitution(model.beforeSubstitution);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Boolean getBeforeSubstitution() {
            return beforeSubstitution;
        }

        public final void setBeforeSubstitution(Boolean beforeSubstitution) {
            this.beforeSubstitution = beforeSubstitution;
        }

        @Override
        public final Builder beforeSubstitution(Boolean beforeSubstitution) {
            this.beforeSubstitution = beforeSubstitution;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetJobDocumentRequest build() {
            return new GetJobDocumentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
