/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCommandResponse extends IotResponse implements
        ToCopyableBuilder<GetCommandResponse.Builder, GetCommandResponse> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commandId").getter(getter(GetCommandResponse::commandId)).setter(setter(Builder::commandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandId").build()).build();

    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commandArn").getter(getter(GetCommandResponse::commandArn)).setter(setter(Builder::commandArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(GetCommandResponse::namespaceAsString)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetCommandResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetCommandResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<CommandParameter>> MANDATORY_PARAMETERS_FIELD = SdkField
            .<List<CommandParameter>> builder(MarshallingType.LIST)
            .memberName("mandatoryParameters")
            .getter(getter(GetCommandResponse::mandatoryParameters))
            .setter(setter(Builder::mandatoryParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mandatoryParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommandParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommandParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CommandPayload> PAYLOAD_FIELD = SdkField.<CommandPayload> builder(MarshallingType.SDK_POJO)
            .memberName("payload").getter(getter(GetCommandResponse::payload)).setter(setter(Builder::payload))
            .constructor(CommandPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetCommandResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetCommandResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(GetCommandResponse::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<Boolean> DEPRECATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deprecated").getter(getter(GetCommandResponse::deprecated)).setter(setter(Builder::deprecated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecated").build()).build();

    private static final SdkField<Boolean> PENDING_DELETION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("pendingDeletion").getter(getter(GetCommandResponse::pendingDeletion))
            .setter(setter(Builder::pendingDeletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingDeletion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD,
            COMMAND_ARN_FIELD, NAMESPACE_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, MANDATORY_PARAMETERS_FIELD, PAYLOAD_FIELD,
            ROLE_ARN_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, DEPRECATED_FIELD, PENDING_DELETION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String commandId;

    private final String commandArn;

    private final String namespace;

    private final String displayName;

    private final String description;

    private final List<CommandParameter> mandatoryParameters;

    private final CommandPayload payload;

    private final String roleArn;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Boolean deprecated;

    private final Boolean pendingDeletion;

    private GetCommandResponse(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.commandArn = builder.commandArn;
        this.namespace = builder.namespace;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.mandatoryParameters = builder.mandatoryParameters;
        this.payload = builder.payload;
        this.roleArn = builder.roleArn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.deprecated = builder.deprecated;
        this.pendingDeletion = builder.pendingDeletion;
    }

    /**
     * <p>
     * The unique identifier of the command.
     * </p>
     * 
     * @return The unique identifier of the command.
     */
    public final String commandId() {
        return commandId;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the command. For example,
     * <code>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandId&gt;</code>
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the command. For example,
     *         <code>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandId&gt;</code>
     */
    public final String commandArn() {
        return commandArn;
    }

    /**
     * <p>
     * The namespace of the command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link CommandNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace of the command.
     * @see CommandNamespace
     */
    public final CommandNamespace namespace() {
        return CommandNamespace.fromValue(namespace);
    }

    /**
     * <p>
     * The namespace of the command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link CommandNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace of the command.
     * @see CommandNamespace
     */
    public final String namespaceAsString() {
        return namespace;
    }

    /**
     * <p>
     * The user-friendly name in the console for the command.
     * </p>
     * 
     * @return The user-friendly name in the console for the command.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A short text description of the command.
     * </p>
     * 
     * @return A short text description of the command.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the MandatoryParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMandatoryParameters() {
        return mandatoryParameters != null && !(mandatoryParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameters for the command created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMandatoryParameters} method.
     * </p>
     * 
     * @return A list of parameters for the command created.
     */
    public final List<CommandParameter> mandatoryParameters() {
        return mandatoryParameters;
    }

    /**
     * <p>
     * The payload object that you provided for the command.
     * </p>
     * 
     * @return The payload object that you provided for the command.
     */
    public final CommandPayload payload() {
        return payload;
    }

    /**
     * <p>
     * The IAM role that you provided when creating the command with <code>AWS-IoT-FleetWise</code> as the namespace.
     * </p>
     * 
     * @return The IAM role that you provided when creating the command with <code>AWS-IoT-FleetWise</code> as the
     *         namespace.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The timestamp, when the command was created.
     * </p>
     * 
     * @return The timestamp, when the command was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp, when the command was last updated.
     * </p>
     * 
     * @return The timestamp, when the command was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * Indicates whether the command has been deprecated.
     * </p>
     * 
     * @return Indicates whether the command has been deprecated.
     */
    public final Boolean deprecated() {
        return deprecated;
    }

    /**
     * <p>
     * Indicates whether the command is being deleted.
     * </p>
     * 
     * @return Indicates whether the command is being deleted.
     */
    public final Boolean pendingDeletion() {
        return pendingDeletion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commandId());
        hashCode = 31 * hashCode + Objects.hashCode(commandArn());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasMandatoryParameters() ? mandatoryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(deprecated());
        hashCode = 31 * hashCode + Objects.hashCode(pendingDeletion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandResponse)) {
            return false;
        }
        GetCommandResponse other = (GetCommandResponse) obj;
        return Objects.equals(commandId(), other.commandId()) && Objects.equals(commandArn(), other.commandArn())
                && Objects.equals(namespaceAsString(), other.namespaceAsString())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && hasMandatoryParameters() == other.hasMandatoryParameters()
                && Objects.equals(mandatoryParameters(), other.mandatoryParameters())
                && Objects.equals(payload(), other.payload()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(deprecated(), other.deprecated()) && Objects.equals(pendingDeletion(), other.pendingDeletion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCommandResponse").add("CommandId", commandId()).add("CommandArn", commandArn())
                .add("Namespace", namespaceAsString()).add("DisplayName", displayName()).add("Description", description())
                .add("MandatoryParameters", hasMandatoryParameters() ? mandatoryParameters() : null).add("Payload", payload())
                .add("RoleArn", roleArn()).add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("Deprecated", deprecated()).add("PendingDeletion", pendingDeletion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commandId":
            return Optional.ofNullable(clazz.cast(commandId()));
        case "commandArn":
            return Optional.ofNullable(clazz.cast(commandArn()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespaceAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "mandatoryParameters":
            return Optional.ofNullable(clazz.cast(mandatoryParameters()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "deprecated":
            return Optional.ofNullable(clazz.cast(deprecated()));
        case "pendingDeletion":
            return Optional.ofNullable(clazz.cast(pendingDeletion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commandId", COMMAND_ID_FIELD);
        map.put("commandArn", COMMAND_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("mandatoryParameters", MANDATORY_PARAMETERS_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("deprecated", DEPRECATED_FIELD);
        map.put("pendingDeletion", PENDING_DELETION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCommandResponse, T> g) {
        return obj -> g.apply((GetCommandResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCommandResponse> {
        /**
         * <p>
         * The unique identifier of the command.
         * </p>
         * 
         * @param commandId
         *        The unique identifier of the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the command. For example,
         * <code>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandId&gt;</code>
         * </p>
         * 
         * @param commandArn
         *        The Amazon Resource Number (ARN) of the command. For example,
         *        <code>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandId&gt;</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandArn(String commandArn);

        /**
         * <p>
         * The namespace of the command.
         * </p>
         * 
         * @param namespace
         *        The namespace of the command.
         * @see CommandNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandNamespace
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The namespace of the command.
         * </p>
         * 
         * @param namespace
         *        The namespace of the command.
         * @see CommandNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandNamespace
         */
        Builder namespace(CommandNamespace namespace);

        /**
         * <p>
         * The user-friendly name in the console for the command.
         * </p>
         * 
         * @param displayName
         *        The user-friendly name in the console for the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A short text description of the command.
         * </p>
         * 
         * @param description
         *        A short text description of the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of parameters for the command created.
         * </p>
         * 
         * @param mandatoryParameters
         *        A list of parameters for the command created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mandatoryParameters(Collection<CommandParameter> mandatoryParameters);

        /**
         * <p>
         * A list of parameters for the command created.
         * </p>
         * 
         * @param mandatoryParameters
         *        A list of parameters for the command created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mandatoryParameters(CommandParameter... mandatoryParameters);

        /**
         * <p>
         * A list of parameters for the command created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.CommandParameter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.CommandParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.CommandParameter.Builder#build()} is called immediately and
         * its result is passed to {@link #mandatoryParameters(List<CommandParameter>)}.
         * 
         * @param mandatoryParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.CommandParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mandatoryParameters(java.util.Collection<CommandParameter>)
         */
        Builder mandatoryParameters(Consumer<CommandParameter.Builder>... mandatoryParameters);

        /**
         * <p>
         * The payload object that you provided for the command.
         * </p>
         * 
         * @param payload
         *        The payload object that you provided for the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(CommandPayload payload);

        /**
         * <p>
         * The payload object that you provided for the command.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommandPayload.Builder} avoiding the need
         * to create one manually via {@link CommandPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommandPayload.Builder#build()} is called immediately and its
         * result is passed to {@link #payload(CommandPayload)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link CommandPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(CommandPayload)
         */
        default Builder payload(Consumer<CommandPayload.Builder> payload) {
            return payload(CommandPayload.builder().applyMutation(payload).build());
        }

        /**
         * <p>
         * The IAM role that you provided when creating the command with <code>AWS-IoT-FleetWise</code> as the
         * namespace.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that you provided when creating the command with <code>AWS-IoT-FleetWise</code> as the
         *        namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The timestamp, when the command was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp, when the command was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp, when the command was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp, when the command was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * Indicates whether the command has been deprecated.
         * </p>
         * 
         * @param deprecated
         *        Indicates whether the command has been deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecated(Boolean deprecated);

        /**
         * <p>
         * Indicates whether the command is being deleted.
         * </p>
         * 
         * @param pendingDeletion
         *        Indicates whether the command is being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingDeletion(Boolean pendingDeletion);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String commandId;

        private String commandArn;

        private String namespace;

        private String displayName;

        private String description;

        private List<CommandParameter> mandatoryParameters = DefaultSdkAutoConstructList.getInstance();

        private CommandPayload payload;

        private String roleArn;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Boolean deprecated;

        private Boolean pendingDeletion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandResponse model) {
            super(model);
            commandId(model.commandId);
            commandArn(model.commandArn);
            namespace(model.namespace);
            displayName(model.displayName);
            description(model.description);
            mandatoryParameters(model.mandatoryParameters);
            payload(model.payload);
            roleArn(model.roleArn);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            deprecated(model.deprecated);
            pendingDeletion(model.pendingDeletion);
        }

        public final String getCommandId() {
            return commandId;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final String getCommandArn() {
            return commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(CommandNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<CommandParameter.Builder> getMandatoryParameters() {
            List<CommandParameter.Builder> result = CommandParameterListCopier.copyToBuilder(this.mandatoryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMandatoryParameters(Collection<CommandParameter.BuilderImpl> mandatoryParameters) {
            this.mandatoryParameters = CommandParameterListCopier.copyFromBuilder(mandatoryParameters);
        }

        @Override
        public final Builder mandatoryParameters(Collection<CommandParameter> mandatoryParameters) {
            this.mandatoryParameters = CommandParameterListCopier.copy(mandatoryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mandatoryParameters(CommandParameter... mandatoryParameters) {
            mandatoryParameters(Arrays.asList(mandatoryParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mandatoryParameters(Consumer<CommandParameter.Builder>... mandatoryParameters) {
            mandatoryParameters(Stream.of(mandatoryParameters).map(c -> CommandParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CommandPayload.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(CommandPayload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(CommandPayload payload) {
            this.payload = payload;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Boolean getDeprecated() {
            return deprecated;
        }

        public final void setDeprecated(Boolean deprecated) {
            this.deprecated = deprecated;
        }

        @Override
        public final Builder deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public final Boolean getPendingDeletion() {
            return pendingDeletion;
        }

        public final void setPendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
        }

        @Override
        public final Builder pendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
            return this;
        }

        @Override
        public GetCommandResponse build() {
            return new GetCommandResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
