/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A geolocation target that you select to index. Each geolocation target contains a <code>name</code> and
 * <code>order</code> key-value pair that specifies the geolocation target fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoLocationTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<GeoLocationTarget.Builder, GeoLocationTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GeoLocationTarget::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("order")
            .getter(getter(GeoLocationTarget::orderAsString)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String order;

    private GeoLocationTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.order = builder.order;
    }

    /**
     * <p>
     * The <code>name</code> of the geolocation target field. If the target field is part of a named shadow, you must
     * select the named shadow using the <code>namedShadow</code> filter.
     * </p>
     * 
     * @return The <code>name</code> of the geolocation target field. If the target field is part of a named shadow, you
     *         must select the named shadow using the <code>namedShadow</code> filter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The <code>order</code> of the geolocation target field. This field is optional. The default value is
     * <code>LatLon</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link TargetFieldOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The <code>order</code> of the geolocation target field. This field is optional. The default value is
     *         <code>LatLon</code>.
     * @see TargetFieldOrder
     */
    public final TargetFieldOrder order() {
        return TargetFieldOrder.fromValue(order);
    }

    /**
     * <p>
     * The <code>order</code> of the geolocation target field. This field is optional. The default value is
     * <code>LatLon</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link TargetFieldOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The <code>order</code> of the geolocation target field. This field is optional. The default value is
     *         <code>LatLon</code>.
     * @see TargetFieldOrder
     */
    public final String orderAsString() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(orderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoLocationTarget)) {
            return false;
        }
        GeoLocationTarget other = (GeoLocationTarget) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(orderAsString(), other.orderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeoLocationTarget").add("Name", name()).add("Order", orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "order":
            return Optional.ofNullable(clazz.cast(orderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("order", ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeoLocationTarget, T> g) {
        return obj -> g.apply((GeoLocationTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeoLocationTarget> {
        /**
         * <p>
         * The <code>name</code> of the geolocation target field. If the target field is part of a named shadow, you
         * must select the named shadow using the <code>namedShadow</code> filter.
         * </p>
         * 
         * @param name
         *        The <code>name</code> of the geolocation target field. If the target field is part of a named shadow,
         *        you must select the named shadow using the <code>namedShadow</code> filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The <code>order</code> of the geolocation target field. This field is optional. The default value is
         * <code>LatLon</code>.
         * </p>
         * 
         * @param order
         *        The <code>order</code> of the geolocation target field. This field is optional. The default value is
         *        <code>LatLon</code>.
         * @see TargetFieldOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetFieldOrder
         */
        Builder order(String order);

        /**
         * <p>
         * The <code>order</code> of the geolocation target field. This field is optional. The default value is
         * <code>LatLon</code>.
         * </p>
         * 
         * @param order
         *        The <code>order</code> of the geolocation target field. This field is optional. The default value is
         *        <code>LatLon</code>.
         * @see TargetFieldOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetFieldOrder
         */
        Builder order(TargetFieldOrder order);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoLocationTarget model) {
            name(model.name);
            order(model.order);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOrder() {
            return order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(TargetFieldOrder order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        @Override
        public GeoLocationTarget build() {
            return new GeoLocationTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
