/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a particular command resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommandSummary implements SdkPojo, Serializable, ToCopyableBuilder<CommandSummary.Builder, CommandSummary> {
    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commandArn").getter(getter(CommandSummary::commandArn)).setter(setter(Builder::commandArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()).build();

    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commandId").getter(getter(CommandSummary::commandId)).setter(setter(Builder::commandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CommandSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Boolean> DEPRECATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deprecated").getter(getter(CommandSummary::deprecated)).setter(setter(Builder::deprecated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecated").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CommandSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(CommandSummary::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<Boolean> PENDING_DELETION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("pendingDeletion").getter(getter(CommandSummary::pendingDeletion))
            .setter(setter(Builder::pendingDeletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingDeletion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ARN_FIELD,
            COMMAND_ID_FIELD, DISPLAY_NAME_FIELD, DEPRECATED_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD,
            PENDING_DELETION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String commandArn;

    private final String commandId;

    private final String displayName;

    private final Boolean deprecated;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Boolean pendingDeletion;

    private CommandSummary(BuilderImpl builder) {
        this.commandArn = builder.commandArn;
        this.commandId = builder.commandId;
        this.displayName = builder.displayName;
        this.deprecated = builder.deprecated;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.pendingDeletion = builder.pendingDeletion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the command.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the command.
     */
    public final String commandArn() {
        return commandArn;
    }

    /**
     * <p>
     * The unique identifier of the command.
     * </p>
     * 
     * @return The unique identifier of the command.
     */
    public final String commandId() {
        return commandId;
    }

    /**
     * <p>
     * The display name of the command.
     * </p>
     * 
     * @return The display name of the command.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Indicates whether the command has been deprecated.
     * </p>
     * 
     * @return Indicates whether the command has been deprecated.
     */
    public final Boolean deprecated() {
        return deprecated;
    }

    /**
     * <p>
     * The timestamp, when the command was created.
     * </p>
     * 
     * @return The timestamp, when the command was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp, when the command was last updated.
     * </p>
     * 
     * @return The timestamp, when the command was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * Indicates whether the command is pending deletion.
     * </p>
     * 
     * @return Indicates whether the command is pending deletion.
     */
    public final Boolean pendingDeletion() {
        return pendingDeletion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commandArn());
        hashCode = 31 * hashCode + Objects.hashCode(commandId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(deprecated());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(pendingDeletion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandSummary)) {
            return false;
        }
        CommandSummary other = (CommandSummary) obj;
        return Objects.equals(commandArn(), other.commandArn()) && Objects.equals(commandId(), other.commandId())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(deprecated(), other.deprecated())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(pendingDeletion(), other.pendingDeletion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommandSummary").add("CommandArn", commandArn()).add("CommandId", commandId())
                .add("DisplayName", displayName()).add("Deprecated", deprecated()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("PendingDeletion", pendingDeletion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commandArn":
            return Optional.ofNullable(clazz.cast(commandArn()));
        case "commandId":
            return Optional.ofNullable(clazz.cast(commandId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "deprecated":
            return Optional.ofNullable(clazz.cast(deprecated()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "pendingDeletion":
            return Optional.ofNullable(clazz.cast(pendingDeletion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commandArn", COMMAND_ARN_FIELD);
        map.put("commandId", COMMAND_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("deprecated", DEPRECATED_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("pendingDeletion", PENDING_DELETION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandSummary, T> g) {
        return obj -> g.apply((CommandSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommandSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the command.
         * </p>
         * 
         * @param commandArn
         *        The Amazon Resource Name (ARN) of the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandArn(String commandArn);

        /**
         * <p>
         * The unique identifier of the command.
         * </p>
         * 
         * @param commandId
         *        The unique identifier of the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * The display name of the command.
         * </p>
         * 
         * @param displayName
         *        The display name of the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Indicates whether the command has been deprecated.
         * </p>
         * 
         * @param deprecated
         *        Indicates whether the command has been deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecated(Boolean deprecated);

        /**
         * <p>
         * The timestamp, when the command was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp, when the command was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp, when the command was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp, when the command was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * Indicates whether the command is pending deletion.
         * </p>
         * 
         * @param pendingDeletion
         *        Indicates whether the command is pending deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingDeletion(Boolean pendingDeletion);
    }

    static final class BuilderImpl implements Builder {
        private String commandArn;

        private String commandId;

        private String displayName;

        private Boolean deprecated;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Boolean pendingDeletion;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandSummary model) {
            commandArn(model.commandArn);
            commandId(model.commandId);
            displayName(model.displayName);
            deprecated(model.deprecated);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            pendingDeletion(model.pendingDeletion);
        }

        public final String getCommandArn() {
            return commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        public final String getCommandId() {
            return commandId;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Boolean getDeprecated() {
            return deprecated;
        }

        public final void setDeprecated(Boolean deprecated) {
            this.deprecated = deprecated;
        }

        @Override
        public final Builder deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Boolean getPendingDeletion() {
            return pendingDeletion;
        }

        public final void setPendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
        }

        @Override
        public final Builder pendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
            return this;
        }

        @Override
        public CommandSummary build() {
            return new CommandSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
