/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A map of key-value pairs that describe the command.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommandParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<CommandParameter.Builder, CommandParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CommandParameter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<CommandParameterValue> VALUE_FIELD = SdkField
            .<CommandParameterValue> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(CommandParameter::value)).setter(setter(Builder::value)).constructor(CommandParameterValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<CommandParameterValue> DEFAULT_VALUE_FIELD = SdkField
            .<CommandParameterValue> builder(MarshallingType.SDK_POJO).memberName("defaultValue")
            .getter(getter(CommandParameter::defaultValue)).setter(setter(Builder::defaultValue))
            .constructor(CommandParameterValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CommandParameter::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD,
            DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final CommandParameterValue value;

    private final CommandParameterValue defaultValue;

    private final String description;

    private CommandParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of a specific parameter used in a command and command execution.
     * </p>
     * 
     * @return The name of a specific parameter used in a command and command execution.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value used to describe the command. When you assign a value to a parameter, it will override any default
     * value that you had already specified.
     * </p>
     * 
     * @return The value used to describe the command. When you assign a value to a parameter, it will override any
     *         default value that you had already specified.
     */
    public final CommandParameterValue value() {
        return value;
    }

    /**
     * <p>
     * The default value used to describe the command. This is the value assumed by the parameter if no other value is
     * assigned to it.
     * </p>
     * 
     * @return The default value used to describe the command. This is the value assumed by the parameter if no other
     *         value is assigned to it.
     */
    public final CommandParameterValue defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The description of the command parameter.
     * </p>
     * 
     * @return The description of the command parameter.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandParameter)) {
            return false;
        }
        CommandParameter other = (CommandParameter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value())
                && Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommandParameter").add("Name", name()).add("Value", value()).add("DefaultValue", defaultValue())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandParameter, T> g) {
        return obj -> g.apply((CommandParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommandParameter> {
        /**
         * <p>
         * The name of a specific parameter used in a command and command execution.
         * </p>
         * 
         * @param name
         *        The name of a specific parameter used in a command and command execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value used to describe the command. When you assign a value to a parameter, it will override any default
         * value that you had already specified.
         * </p>
         * 
         * @param value
         *        The value used to describe the command. When you assign a value to a parameter, it will override any
         *        default value that you had already specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(CommandParameterValue value);

        /**
         * <p>
         * The value used to describe the command. When you assign a value to a parameter, it will override any default
         * value that you had already specified.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommandParameterValue.Builder} avoiding
         * the need to create one manually via {@link CommandParameterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommandParameterValue.Builder#build()} is called immediately and
         * its result is passed to {@link #value(CommandParameterValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link CommandParameterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(CommandParameterValue)
         */
        default Builder value(Consumer<CommandParameterValue.Builder> value) {
            return value(CommandParameterValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The default value used to describe the command. This is the value assumed by the parameter if no other value
         * is assigned to it.
         * </p>
         * 
         * @param defaultValue
         *        The default value used to describe the command. This is the value assumed by the parameter if no other
         *        value is assigned to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(CommandParameterValue defaultValue);

        /**
         * <p>
         * The default value used to describe the command. This is the value assumed by the parameter if no other value
         * is assigned to it.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommandParameterValue.Builder} avoiding
         * the need to create one manually via {@link CommandParameterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommandParameterValue.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultValue(CommandParameterValue)}.
         * 
         * @param defaultValue
         *        a consumer that will call methods on {@link CommandParameterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValue(CommandParameterValue)
         */
        default Builder defaultValue(Consumer<CommandParameterValue.Builder> defaultValue) {
            return defaultValue(CommandParameterValue.builder().applyMutation(defaultValue).build());
        }

        /**
         * <p>
         * The description of the command parameter.
         * </p>
         * 
         * @param description
         *        The description of the command parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private CommandParameterValue value;

        private CommandParameterValue defaultValue;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandParameter model) {
            name(model.name);
            value(model.value);
            defaultValue(model.defaultValue);
            description(model.description);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CommandParameterValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(CommandParameterValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(CommandParameterValue value) {
            this.value = value;
            return this;
        }

        public final CommandParameterValue.Builder getDefaultValue() {
            return defaultValue != null ? defaultValue.toBuilder() : null;
        }

        public final void setDefaultValue(CommandParameterValue.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        @Override
        public final Builder defaultValue(CommandParameterValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public CommandParameter build() {
            return new CommandParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
