/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for the rollout of OTA updates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsJobExecutionsRolloutConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsJobExecutionsRolloutConfig.Builder, AwsJobExecutionsRolloutConfig> {
    private static final SdkField<Integer> MAXIMUM_PER_MINUTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumPerMinute").getter(getter(AwsJobExecutionsRolloutConfig::maximumPerMinute))
            .setter(setter(Builder::maximumPerMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPerMinute").build()).build();

    private static final SdkField<AwsJobExponentialRolloutRate> EXPONENTIAL_RATE_FIELD = SdkField
            .<AwsJobExponentialRolloutRate> builder(MarshallingType.SDK_POJO).memberName("exponentialRate")
            .getter(getter(AwsJobExecutionsRolloutConfig::exponentialRate)).setter(setter(Builder::exponentialRate))
            .constructor(AwsJobExponentialRolloutRate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exponentialRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_PER_MINUTE_FIELD,
            EXPONENTIAL_RATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maximumPerMinute;

    private final AwsJobExponentialRolloutRate exponentialRate;

    private AwsJobExecutionsRolloutConfig(BuilderImpl builder) {
        this.maximumPerMinute = builder.maximumPerMinute;
        this.exponentialRate = builder.exponentialRate;
    }

    /**
     * <p>
     * The maximum number of OTA update job executions started per minute.
     * </p>
     * 
     * @return The maximum number of OTA update job executions started per minute.
     */
    public final Integer maximumPerMinute() {
        return maximumPerMinute;
    }

    /**
     * <p>
     * The rate of increase for a job rollout. This parameter allows you to define an exponential rate increase for a
     * job rollout.
     * </p>
     * 
     * @return The rate of increase for a job rollout. This parameter allows you to define an exponential rate increase
     *         for a job rollout.
     */
    public final AwsJobExponentialRolloutRate exponentialRate() {
        return exponentialRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumPerMinute());
        hashCode = 31 * hashCode + Objects.hashCode(exponentialRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsJobExecutionsRolloutConfig)) {
            return false;
        }
        AwsJobExecutionsRolloutConfig other = (AwsJobExecutionsRolloutConfig) obj;
        return Objects.equals(maximumPerMinute(), other.maximumPerMinute())
                && Objects.equals(exponentialRate(), other.exponentialRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsJobExecutionsRolloutConfig").add("MaximumPerMinute", maximumPerMinute())
                .add("ExponentialRate", exponentialRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maximumPerMinute":
            return Optional.ofNullable(clazz.cast(maximumPerMinute()));
        case "exponentialRate":
            return Optional.ofNullable(clazz.cast(exponentialRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maximumPerMinute", MAXIMUM_PER_MINUTE_FIELD);
        map.put("exponentialRate", EXPONENTIAL_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsJobExecutionsRolloutConfig, T> g) {
        return obj -> g.apply((AwsJobExecutionsRolloutConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsJobExecutionsRolloutConfig> {
        /**
         * <p>
         * The maximum number of OTA update job executions started per minute.
         * </p>
         * 
         * @param maximumPerMinute
         *        The maximum number of OTA update job executions started per minute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPerMinute(Integer maximumPerMinute);

        /**
         * <p>
         * The rate of increase for a job rollout. This parameter allows you to define an exponential rate increase for
         * a job rollout.
         * </p>
         * 
         * @param exponentialRate
         *        The rate of increase for a job rollout. This parameter allows you to define an exponential rate
         *        increase for a job rollout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exponentialRate(AwsJobExponentialRolloutRate exponentialRate);

        /**
         * <p>
         * The rate of increase for a job rollout. This parameter allows you to define an exponential rate increase for
         * a job rollout.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsJobExponentialRolloutRate.Builder}
         * avoiding the need to create one manually via {@link AwsJobExponentialRolloutRate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsJobExponentialRolloutRate.Builder#build()} is called
         * immediately and its result is passed to {@link #exponentialRate(AwsJobExponentialRolloutRate)}.
         * 
         * @param exponentialRate
         *        a consumer that will call methods on {@link AwsJobExponentialRolloutRate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exponentialRate(AwsJobExponentialRolloutRate)
         */
        default Builder exponentialRate(Consumer<AwsJobExponentialRolloutRate.Builder> exponentialRate) {
            return exponentialRate(AwsJobExponentialRolloutRate.builder().applyMutation(exponentialRate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumPerMinute;

        private AwsJobExponentialRolloutRate exponentialRate;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsJobExecutionsRolloutConfig model) {
            maximumPerMinute(model.maximumPerMinute);
            exponentialRate(model.exponentialRate);
        }

        public final Integer getMaximumPerMinute() {
            return maximumPerMinute;
        }

        public final void setMaximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
        }

        @Override
        public final Builder maximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
            return this;
        }

        public final AwsJobExponentialRolloutRate.Builder getExponentialRate() {
            return exponentialRate != null ? exponentialRate.toBuilder() : null;
        }

        public final void setExponentialRate(AwsJobExponentialRolloutRate.BuilderImpl exponentialRate) {
            this.exponentialRate = exponentialRate != null ? exponentialRate.build() : null;
        }

        @Override
        public final Builder exponentialRate(AwsJobExponentialRolloutRate exponentialRate) {
            this.exponentialRate = exponentialRate;
            return this;
        }

        @Override
        public AwsJobExecutionsRolloutConfig build() {
            return new AwsJobExecutionsRolloutConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
