/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authorizer summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizerSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthorizerSummary.Builder, AuthorizerSummary> {
    private static final SdkField<String> AUTHORIZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizerName").getter(getter(AuthorizerSummary::authorizerName))
            .setter(setter(Builder::authorizerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerName").build()).build();

    private static final SdkField<String> AUTHORIZER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizerArn").getter(getter(AuthorizerSummary::authorizerArn)).setter(setter(Builder::authorizerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZER_NAME_FIELD,
            AUTHORIZER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authorizerName;

    private final String authorizerArn;

    private AuthorizerSummary(BuilderImpl builder) {
        this.authorizerName = builder.authorizerName;
        this.authorizerArn = builder.authorizerArn;
    }

    /**
     * <p>
     * The authorizer name.
     * </p>
     * 
     * @return The authorizer name.
     */
    public final String authorizerName() {
        return authorizerName;
    }

    /**
     * <p>
     * The authorizer ARN.
     * </p>
     * 
     * @return The authorizer ARN.
     */
    public final String authorizerArn() {
        return authorizerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizerSummary)) {
            return false;
        }
        AuthorizerSummary other = (AuthorizerSummary) obj;
        return Objects.equals(authorizerName(), other.authorizerName()) && Objects.equals(authorizerArn(), other.authorizerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizerSummary").add("AuthorizerName", authorizerName())
                .add("AuthorizerArn", authorizerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizerName":
            return Optional.ofNullable(clazz.cast(authorizerName()));
        case "authorizerArn":
            return Optional.ofNullable(clazz.cast(authorizerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authorizerName", AUTHORIZER_NAME_FIELD);
        map.put("authorizerArn", AUTHORIZER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizerSummary, T> g) {
        return obj -> g.apply((AuthorizerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthorizerSummary> {
        /**
         * <p>
         * The authorizer name.
         * </p>
         * 
         * @param authorizerName
         *        The authorizer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerName(String authorizerName);

        /**
         * <p>
         * The authorizer ARN.
         * </p>
         * 
         * @param authorizerArn
         *        The authorizer ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerArn(String authorizerArn);
    }

    static final class BuilderImpl implements Builder {
        private String authorizerName;

        private String authorizerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizerSummary model) {
            authorizerName(model.authorizerName);
            authorizerArn(model.authorizerArn);
        }

        public final String getAuthorizerName() {
            return authorizerName;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        @Override
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final String getAuthorizerArn() {
            return authorizerArn;
        }

        public final void setAuthorizerArn(String authorizerArn) {
            this.authorizerArn = authorizerArn;
        }

        @Override
        public final Builder authorizerArn(String authorizerArn) {
            this.authorizerArn = authorizerArn;
            return this;
        }

        @Override
        public AuthorizerSummary build() {
            return new AuthorizerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
