/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.iot.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * TopicRule JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class TopicRuleUnmarshaller implements Unmarshaller<TopicRule, JsonUnmarshallerContext> {

    public TopicRule unmarshall(JsonUnmarshallerContext context) throws Exception {
        TopicRule.Builder topicRuleBuilder = TopicRule.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ruleName", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.ruleName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("sql", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.sql(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.createdAt(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("actions", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.actions(new ListUnmarshaller<Action>(ActionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ruleDisabled", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.ruleDisabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("awsIotSqlVersion", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.awsIotSqlVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return topicRuleBuilder.build();
    }

    private static final TopicRuleUnmarshaller INSTANCE = new TopicRuleUnmarshaller();

    public static TopicRuleUnmarshaller getInstance() {
        return INSTANCE;
    }
}
