/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CloudwatchMetricAction;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CloudwatchMetricAction} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CloudwatchMetricActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();

    private static final MarshallingInfo<String> METRICNAMESPACE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricNamespace").isBinary(false).build();

    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricName").isBinary(false).build();

    private static final MarshallingInfo<String> METRICVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricValue").isBinary(false).build();

    private static final MarshallingInfo<String> METRICUNIT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricUnit").isBinary(false).build();

    private static final MarshallingInfo<String> METRICTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricTimestamp").isBinary(false).build();

    private static final CloudwatchMetricActionMarshaller INSTANCE = new CloudwatchMetricActionMarshaller();

    private CloudwatchMetricActionMarshaller() {
    }

    public static CloudwatchMetricActionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CloudwatchMetricAction cloudwatchMetricAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(cloudwatchMetricAction, "cloudwatchMetricAction");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(cloudwatchMetricAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(cloudwatchMetricAction.metricNamespace(), METRICNAMESPACE_BINDING);
            protocolMarshaller.marshall(cloudwatchMetricAction.metricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall(cloudwatchMetricAction.metricValue(), METRICVALUE_BINDING);
            protocolMarshaller.marshall(cloudwatchMetricAction.metricUnit(), METRICUNIT_BINDING);
            protocolMarshaller.marshall(cloudwatchMetricAction.metricTimestamp(), METRICTIMESTAMP_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
