/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.ThingTypePropertiesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ThingTypeProperties contains information about the thing type including: a thing type description, and a list of
 * searchable thing attribute names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ThingTypeProperties implements StructuredPojo, ToCopyableBuilder<ThingTypeProperties.Builder, ThingTypeProperties> {
    private final String thingTypeDescription;

    private final List<String> searchableAttributes;

    private ThingTypeProperties(BuilderImpl builder) {
        this.thingTypeDescription = builder.thingTypeDescription;
        this.searchableAttributes = builder.searchableAttributes;
    }

    /**
     * <p>
     * The description of the thing type.
     * </p>
     * 
     * @return The description of the thing type.
     */
    public String thingTypeDescription() {
        return thingTypeDescription;
    }

    /**
     * <p>
     * A list of searchable thing attribute names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of searchable thing attribute names.
     */
    public List<String> searchableAttributes() {
        return searchableAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(searchableAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeProperties)) {
            return false;
        }
        ThingTypeProperties other = (ThingTypeProperties) obj;
        return Objects.equals(thingTypeDescription(), other.thingTypeDescription())
                && Objects.equals(searchableAttributes(), other.searchableAttributes());
    }

    @Override
    public String toString() {
        return ToString.builder("ThingTypeProperties").add("ThingTypeDescription", thingTypeDescription())
                .add("SearchableAttributes", searchableAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingTypeDescription":
            return Optional.of(clazz.cast(thingTypeDescription()));
        case "searchableAttributes":
            return Optional.of(clazz.cast(searchableAttributes()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingTypePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ThingTypeProperties> {
        /**
         * <p>
         * The description of the thing type.
         * </p>
         * 
         * @param thingTypeDescription
         *        The description of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeDescription(String thingTypeDescription);

        /**
         * <p>
         * A list of searchable thing attribute names.
         * </p>
         * 
         * @param searchableAttributes
         *        A list of searchable thing attribute names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchableAttributes(Collection<String> searchableAttributes);

        /**
         * <p>
         * A list of searchable thing attribute names.
         * </p>
         * 
         * @param searchableAttributes
         *        A list of searchable thing attribute names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchableAttributes(String... searchableAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String thingTypeDescription;

        private List<String> searchableAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeProperties model) {
            thingTypeDescription(model.thingTypeDescription);
            searchableAttributes(model.searchableAttributes);
        }

        public final String getThingTypeDescription() {
            return thingTypeDescription;
        }

        @Override
        public final Builder thingTypeDescription(String thingTypeDescription) {
            this.thingTypeDescription = thingTypeDescription;
            return this;
        }

        public final void setThingTypeDescription(String thingTypeDescription) {
            this.thingTypeDescription = thingTypeDescription;
        }

        public final Collection<String> getSearchableAttributes() {
            return searchableAttributes;
        }

        @Override
        public final Builder searchableAttributes(Collection<String> searchableAttributes) {
            this.searchableAttributes = SearchableAttributesCopier.copy(searchableAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchableAttributes(String... searchableAttributes) {
            searchableAttributes(Arrays.asList(searchableAttributes));
            return this;
        }

        public final void setSearchableAttributes(Collection<String> searchableAttributes) {
            this.searchableAttributes = SearchableAttributesCopier.copy(searchableAttributes);
        }

        @Override
        public ThingTypeProperties build() {
            return new ThingTypeProperties(this);
        }
    }
}
