/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.SqsActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to publish data to an Amazon SQS queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SqsAction implements StructuredPojo, ToCopyableBuilder<SqsAction.Builder, SqsAction> {
    private final String roleArn;

    private final String queueUrl;

    private final Boolean useBase64;

    private SqsAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.queueUrl = builder.queueUrl;
        this.useBase64 = builder.useBase64;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * Specifies whether to use Base64 encoding.
     * </p>
     * 
     * @return Specifies whether to use Base64 encoding.
     */
    public Boolean useBase64() {
        return useBase64;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(useBase64());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqsAction)) {
            return false;
        }
        SqsAction other = (SqsAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(queueUrl(), other.queueUrl())
                && Objects.equals(useBase64(), other.useBase64());
    }

    @Override
    public String toString() {
        return ToString.builder("SqsAction").add("RoleArn", roleArn()).add("QueueUrl", queueUrl()).add("UseBase64", useBase64())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.of(clazz.cast(roleArn()));
        case "queueUrl":
            return Optional.of(clazz.cast(queueUrl()));
        case "useBase64":
            return Optional.of(clazz.cast(useBase64()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SqsActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SqsAction> {
        /**
         * <p>
         * The ARN of the IAM role that grants access.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The URL of the Amazon SQS queue.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * Specifies whether to use Base64 encoding.
         * </p>
         * 
         * @param useBase64
         *        Specifies whether to use Base64 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useBase64(Boolean useBase64);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String queueUrl;

        private Boolean useBase64;

        private BuilderImpl() {
        }

        private BuilderImpl(SqsAction model) {
            roleArn(model.roleArn);
            queueUrl(model.queueUrl);
            useBase64(model.useBase64);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Boolean getUseBase64() {
            return useBase64;
        }

        @Override
        public final Builder useBase64(Boolean useBase64) {
            this.useBase64 = useBase64;
            return this;
        }

        public final void setUseBase64(Boolean useBase64) {
            this.useBase64 = useBase64;
        }

        @Override
        public SqsAction build() {
            return new SqsAction(this);
        }
    }
}
