/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.PutItemInputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the DynamoActionVS action that specifies the DynamoDB table to which the message data will be written.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutItemInput implements StructuredPojo, ToCopyableBuilder<PutItemInput.Builder, PutItemInput> {
    private final String tableName;

    private PutItemInput(BuilderImpl builder) {
        this.tableName = builder.tableName;
    }

    /**
     * <p>
     * The table where the message data will be written
     * </p>
     * 
     * @return The table where the message data will be written
     */
    public String tableName() {
        return tableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutItemInput)) {
            return false;
        }
        PutItemInput other = (PutItemInput) obj;
        return Objects.equals(tableName(), other.tableName());
    }

    @Override
    public String toString() {
        return ToString.builder("PutItemInput").add("TableName", tableName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableName":
            return Optional.of(clazz.cast(tableName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutItemInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PutItemInput> {
        /**
         * <p>
         * The table where the message data will be written
         * </p>
         * 
         * @param tableName
         *        The table where the message data will be written
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutItemInput model) {
            tableName(model.tableName);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public PutItemInput build() {
            return new PutItemInput(this);
        }
    }
}
