/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListPrincipalPolicies operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListPrincipalPoliciesResponse extends IoTResponse implements
        ToCopyableBuilder<ListPrincipalPoliciesResponse.Builder, ListPrincipalPoliciesResponse> {
    private final List<Policy> policies;

    private final String nextMarker;

    private ListPrincipalPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policies = builder.policies;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The policies.
     */
    public List<Policy> policies() {
        return policies;
    }

    /**
     * <p>
     * The marker for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The marker for the next set of results, or null if there are no additional results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policies());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalPoliciesResponse)) {
            return false;
        }
        ListPrincipalPoliciesResponse other = (ListPrincipalPoliciesResponse) obj;
        return Objects.equals(policies(), other.policies()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("ListPrincipalPoliciesResponse").add("Policies", policies()).add("NextMarker", nextMarker())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policies":
            return Optional.of(clazz.cast(policies()));
        case "nextMarker":
            return Optional.of(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, ListPrincipalPoliciesResponse> {
        /**
         * <p>
         * The policies.
         * </p>
         * 
         * @param policies
         *        The policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<Policy> policies);

        /**
         * <p>
         * The policies.
         * </p>
         * 
         * @param policies
         *        The policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Policy... policies);

        /**
         * <p>
         * The marker for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextMarker
         *        The marker for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private List<Policy> policies;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalPoliciesResponse model) {
            policies(model.policies);
            nextMarker(model.nextMarker);
        }

        public final Collection<Policy.Builder> getPolicies() {
            return policies != null ? policies.stream().map(Policy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policies(Collection<Policy> policies) {
            this.policies = PoliciesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Policy... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        public final void setPolicies(Collection<Policy.BuilderImpl> policies) {
            this.policies = PoliciesCopier.copyFromBuilder(policies);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListPrincipalPoliciesResponse build() {
            return new ListPrincipalPoliciesResponse(this);
        }
    }
}
