/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListOutgoingCertificates operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOutgoingCertificatesResponse extends IoTResponse implements
        ToCopyableBuilder<ListOutgoingCertificatesResponse.Builder, ListOutgoingCertificatesResponse> {
    private final List<OutgoingCertificate> outgoingCertificates;

    private final String nextMarker;

    private ListOutgoingCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.outgoingCertificates = builder.outgoingCertificates;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The certificates that are being transfered but not yet accepted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The certificates that are being transfered but not yet accepted.
     */
    public List<OutgoingCertificate> outgoingCertificates() {
        return outgoingCertificates;
    }

    /**
     * <p>
     * The marker for the next set of results.
     * </p>
     * 
     * @return The marker for the next set of results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outgoingCertificates());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutgoingCertificatesResponse)) {
            return false;
        }
        ListOutgoingCertificatesResponse other = (ListOutgoingCertificatesResponse) obj;
        return Objects.equals(outgoingCertificates(), other.outgoingCertificates())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("ListOutgoingCertificatesResponse").add("OutgoingCertificates", outgoingCertificates())
                .add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outgoingCertificates":
            return Optional.of(clazz.cast(outgoingCertificates()));
        case "nextMarker":
            return Optional.of(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, ListOutgoingCertificatesResponse> {
        /**
         * <p>
         * The certificates that are being transfered but not yet accepted.
         * </p>
         * 
         * @param outgoingCertificates
         *        The certificates that are being transfered but not yet accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingCertificates(Collection<OutgoingCertificate> outgoingCertificates);

        /**
         * <p>
         * The certificates that are being transfered but not yet accepted.
         * </p>
         * 
         * @param outgoingCertificates
         *        The certificates that are being transfered but not yet accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingCertificates(OutgoingCertificate... outgoingCertificates);

        /**
         * <p>
         * The marker for the next set of results.
         * </p>
         * 
         * @param nextMarker
         *        The marker for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private List<OutgoingCertificate> outgoingCertificates;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutgoingCertificatesResponse model) {
            outgoingCertificates(model.outgoingCertificates);
            nextMarker(model.nextMarker);
        }

        public final Collection<OutgoingCertificate.Builder> getOutgoingCertificates() {
            return outgoingCertificates != null ? outgoingCertificates.stream().map(OutgoingCertificate::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outgoingCertificates(Collection<OutgoingCertificate> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copy(outgoingCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outgoingCertificates(OutgoingCertificate... outgoingCertificates) {
            outgoingCertificates(Arrays.asList(outgoingCertificates));
            return this;
        }

        public final void setOutgoingCertificates(Collection<OutgoingCertificate.BuilderImpl> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copyFromBuilder(outgoingCertificates);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListOutgoingCertificatesResponse build() {
            return new ListOutgoingCertificatesResponse(this);
        }
    }
}
