/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.ElasticsearchActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action that writes data to an Amazon Elasticsearch Service domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ElasticsearchAction implements StructuredPojo, ToCopyableBuilder<ElasticsearchAction.Builder, ElasticsearchAction> {
    private final String roleArn;

    private final String endpoint;

    private final String index;

    private final String type;

    private final String id;

    private ElasticsearchAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.endpoint = builder.endpoint;
        this.index = builder.index;
        this.type = builder.type;
        this.id = builder.id;
    }

    /**
     * <p>
     * The IAM role ARN that has access to Elasticsearch.
     * </p>
     * 
     * @return The IAM role ARN that has access to Elasticsearch.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The endpoint of your Elasticsearch domain.
     * </p>
     * 
     * @return The endpoint of your Elasticsearch domain.
     */
    public String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The Elasticsearch index where you want to store your data.
     * </p>
     * 
     * @return The Elasticsearch index where you want to store your data.
     */
    public String index() {
        return index;
    }

    /**
     * <p>
     * The type of document you are storing.
     * </p>
     * 
     * @return The type of document you are storing.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The unique identifier for the document you are storing.
     * </p>
     * 
     * @return The unique identifier for the document you are storing.
     */
    public String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchAction)) {
            return false;
        }
        ElasticsearchAction other = (ElasticsearchAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(index(), other.index()) && Objects.equals(type(), other.type())
                && Objects.equals(id(), other.id());
    }

    @Override
    public String toString() {
        return ToString.builder("ElasticsearchAction").add("RoleArn", roleArn()).add("Endpoint", endpoint())
                .add("Index", index()).add("Type", type()).add("Id", id()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.of(clazz.cast(roleArn()));
        case "endpoint":
            return Optional.of(clazz.cast(endpoint()));
        case "index":
            return Optional.of(clazz.cast(index()));
        case "type":
            return Optional.of(clazz.cast(type()));
        case "id":
            return Optional.of(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ElasticsearchAction> {
        /**
         * <p>
         * The IAM role ARN that has access to Elasticsearch.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN that has access to Elasticsearch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The endpoint of your Elasticsearch domain.
         * </p>
         * 
         * @param endpoint
         *        The endpoint of your Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The Elasticsearch index where you want to store your data.
         * </p>
         * 
         * @param index
         *        The Elasticsearch index where you want to store your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(String index);

        /**
         * <p>
         * The type of document you are storing.
         * </p>
         * 
         * @param type
         *        The type of document you are storing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The unique identifier for the document you are storing.
         * </p>
         * 
         * @param id
         *        The unique identifier for the document you are storing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String endpoint;

        private String index;

        private String type;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchAction model) {
            roleArn(model.roleArn);
            endpoint(model.endpoint);
            index(model.index);
            type(model.type);
            id(model.id);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getIndex() {
            return index;
        }

        @Override
        public final Builder index(String index) {
            this.index = index;
            return this;
        }

        public final void setIndex(String index) {
            this.index = index;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public ElasticsearchAction build() {
            return new ElasticsearchAction(this);
        }
    }
}
