/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the CreateThingType operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateThingTypeResponse extends IoTResponse implements
        ToCopyableBuilder<CreateThingTypeResponse.Builder, CreateThingTypeResponse> {
    private final String thingTypeName;

    private final String thingTypeArn;

    private CreateThingTypeResponse(BuilderImpl builder) {
        super(builder);
        this.thingTypeName = builder.thingTypeName;
        this.thingTypeArn = builder.thingTypeArn;
    }

    /**
     * <p>
     * The name of the thing type.
     * </p>
     * 
     * @return The name of the thing type.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the thing type.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the thing type.
     */
    public String thingTypeArn() {
        return thingTypeArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingTypeResponse)) {
            return false;
        }
        CreateThingTypeResponse other = (CreateThingTypeResponse) obj;
        return Objects.equals(thingTypeName(), other.thingTypeName()) && Objects.equals(thingTypeArn(), other.thingTypeArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateThingTypeResponse").add("ThingTypeName", thingTypeName())
                .add("ThingTypeArn", thingTypeArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingTypeName":
            return Optional.of(clazz.cast(thingTypeName()));
        case "thingTypeArn":
            return Optional.of(clazz.cast(thingTypeArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, CreateThingTypeResponse> {
        /**
         * <p>
         * The name of the thing type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the thing type.
         * </p>
         * 
         * @param thingTypeArn
         *        The Amazon Resource Name (ARN) of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeArn(String thingTypeArn);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private String thingTypeName;

        private String thingTypeArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingTypeResponse model) {
            thingTypeName(model.thingTypeName);
            thingTypeArn(model.thingTypeArn);
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final String getThingTypeArn() {
            return thingTypeArn;
        }

        @Override
        public final Builder thingTypeArn(String thingTypeArn) {
            this.thingTypeArn = thingTypeArn;
            return this;
        }

        public final void setThingTypeArn(String thingTypeArn) {
            this.thingTypeArn = thingTypeArn;
        }

        @Override
        public CreateThingTypeResponse build() {
            return new CreateThingTypeResponse(this);
        }
    }
}
