/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the CreateCertificateFromCsr operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCertificateFromCsrResponse extends IoTResponse implements
        ToCopyableBuilder<CreateCertificateFromCsrResponse.Builder, CreateCertificateFromCsrResponse> {
    private final String certificateArn;

    private final String certificateId;

    private final String certificatePem;

    private CreateCertificateFromCsrResponse(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.certificatePem = builder.certificatePem;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy operations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy
     *         operations.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The ID of the certificate. Certificate management operations only take a certificateId.
     * </p>
     * 
     * @return The ID of the certificate. Certificate management operations only take a certificateId.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The certificate data, in PEM format.
     * </p>
     * 
     * @return The certificate data, in PEM format.
     */
    public String certificatePem() {
        return certificatePem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateFromCsrResponse)) {
            return false;
        }
        CreateCertificateFromCsrResponse other = (CreateCertificateFromCsrResponse) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(certificatePem(), other.certificatePem());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateCertificateFromCsrResponse").add("CertificateArn", certificateArn())
                .add("CertificateId", certificateId()).add("CertificatePem", certificatePem()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.of(clazz.cast(certificateArn()));
        case "certificateId":
            return Optional.of(clazz.cast(certificateId()));
        case "certificatePem":
            return Optional.of(clazz.cast(certificatePem()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, CreateCertificateFromCsrResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy operations.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy
         *        operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The ID of the certificate. Certificate management operations only take a certificateId.
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate. Certificate management operations only take a certificateId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String certificatePem;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateFromCsrResponse model) {
            certificateArn(model.certificateArn);
            certificateId(model.certificateId);
            certificatePem(model.certificatePem);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        @Override
        public CreateCertificateFromCsrResponse build() {
            return new CreateCertificateFromCsrResponse(this);
        }
    }
}
