/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.ActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the actions associated with a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Action implements StructuredPojo, ToCopyableBuilder<Action.Builder, Action> {
    private final DynamoDBAction dynamoDB;

    private final DynamoDBv2Action dynamoDBv2;

    private final LambdaAction lambda;

    private final SnsAction sns;

    private final SqsAction sqs;

    private final KinesisAction kinesis;

    private final RepublishAction republish;

    private final S3Action s3;

    private final FirehoseAction firehose;

    private final CloudwatchMetricAction cloudwatchMetric;

    private final CloudwatchAlarmAction cloudwatchAlarm;

    private final ElasticsearchAction elasticsearch;

    private final SalesforceAction salesforce;

    private Action(BuilderImpl builder) {
        this.dynamoDB = builder.dynamoDB;
        this.dynamoDBv2 = builder.dynamoDBv2;
        this.lambda = builder.lambda;
        this.sns = builder.sns;
        this.sqs = builder.sqs;
        this.kinesis = builder.kinesis;
        this.republish = builder.republish;
        this.s3 = builder.s3;
        this.firehose = builder.firehose;
        this.cloudwatchMetric = builder.cloudwatchMetric;
        this.cloudwatchAlarm = builder.cloudwatchAlarm;
        this.elasticsearch = builder.elasticsearch;
        this.salesforce = builder.salesforce;
    }

    /**
     * <p>
     * Write to a DynamoDB table.
     * </p>
     * 
     * @return Write to a DynamoDB table.
     */
    public DynamoDBAction dynamoDB() {
        return dynamoDB;
    }

    /**
     * <p>
     * Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each attribute in
     * an MQTT message payload into a separate DynamoDB column.
     * </p>
     * 
     * @return Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each
     *         attribute in an MQTT message payload into a separate DynamoDB column.
     */
    public DynamoDBv2Action dynamoDBv2() {
        return dynamoDBv2;
    }

    /**
     * <p>
     * Invoke a Lambda function.
     * </p>
     * 
     * @return Invoke a Lambda function.
     */
    public LambdaAction lambda() {
        return lambda;
    }

    /**
     * <p>
     * Publish to an Amazon SNS topic.
     * </p>
     * 
     * @return Publish to an Amazon SNS topic.
     */
    public SnsAction sns() {
        return sns;
    }

    /**
     * <p>
     * Publish to an Amazon SQS queue.
     * </p>
     * 
     * @return Publish to an Amazon SQS queue.
     */
    public SqsAction sqs() {
        return sqs;
    }

    /**
     * <p>
     * Write data to an Amazon Kinesis stream.
     * </p>
     * 
     * @return Write data to an Amazon Kinesis stream.
     */
    public KinesisAction kinesis() {
        return kinesis;
    }

    /**
     * <p>
     * Publish to another MQTT topic.
     * </p>
     * 
     * @return Publish to another MQTT topic.
     */
    public RepublishAction republish() {
        return republish;
    }

    /**
     * <p>
     * Write to an Amazon S3 bucket.
     * </p>
     * 
     * @return Write to an Amazon S3 bucket.
     */
    public S3Action s3() {
        return s3;
    }

    /**
     * <p>
     * Write to an Amazon Kinesis Firehose stream.
     * </p>
     * 
     * @return Write to an Amazon Kinesis Firehose stream.
     */
    public FirehoseAction firehose() {
        return firehose;
    }

    /**
     * <p>
     * Capture a CloudWatch metric.
     * </p>
     * 
     * @return Capture a CloudWatch metric.
     */
    public CloudwatchMetricAction cloudwatchMetric() {
        return cloudwatchMetric;
    }

    /**
     * <p>
     * Change the state of a CloudWatch alarm.
     * </p>
     * 
     * @return Change the state of a CloudWatch alarm.
     */
    public CloudwatchAlarmAction cloudwatchAlarm() {
        return cloudwatchAlarm;
    }

    /**
     * <p>
     * Write data to an Amazon Elasticsearch Service domain.
     * </p>
     * 
     * @return Write data to an Amazon Elasticsearch Service domain.
     */
    public ElasticsearchAction elasticsearch() {
        return elasticsearch;
    }

    /**
     * <p>
     * Send a message to a Salesforce IoT Cloud Input Stream.
     * </p>
     * 
     * @return Send a message to a Salesforce IoT Cloud Input Stream.
     */
    public SalesforceAction salesforce() {
        return salesforce;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dynamoDB());
        hashCode = 31 * hashCode + Objects.hashCode(dynamoDBv2());
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        hashCode = 31 * hashCode + Objects.hashCode(sns());
        hashCode = 31 * hashCode + Objects.hashCode(sqs());
        hashCode = 31 * hashCode + Objects.hashCode(kinesis());
        hashCode = 31 * hashCode + Objects.hashCode(republish());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(firehose());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchMetric());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearch());
        hashCode = 31 * hashCode + Objects.hashCode(salesforce());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(dynamoDB(), other.dynamoDB()) && Objects.equals(dynamoDBv2(), other.dynamoDBv2())
                && Objects.equals(lambda(), other.lambda()) && Objects.equals(sns(), other.sns())
                && Objects.equals(sqs(), other.sqs()) && Objects.equals(kinesis(), other.kinesis())
                && Objects.equals(republish(), other.republish()) && Objects.equals(s3(), other.s3())
                && Objects.equals(firehose(), other.firehose()) && Objects.equals(cloudwatchMetric(), other.cloudwatchMetric())
                && Objects.equals(cloudwatchAlarm(), other.cloudwatchAlarm())
                && Objects.equals(elasticsearch(), other.elasticsearch()) && Objects.equals(salesforce(), other.salesforce());
    }

    @Override
    public String toString() {
        return ToString.builder("Action").add("DynamoDB", dynamoDB()).add("DynamoDBv2", dynamoDBv2()).add("Lambda", lambda())
                .add("Sns", sns()).add("Sqs", sqs()).add("Kinesis", kinesis()).add("Republish", republish()).add("S3", s3())
                .add("Firehose", firehose()).add("CloudwatchMetric", cloudwatchMetric())
                .add("CloudwatchAlarm", cloudwatchAlarm()).add("Elasticsearch", elasticsearch()).add("Salesforce", salesforce())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dynamoDB":
            return Optional.of(clazz.cast(dynamoDB()));
        case "dynamoDBv2":
            return Optional.of(clazz.cast(dynamoDBv2()));
        case "lambda":
            return Optional.of(clazz.cast(lambda()));
        case "sns":
            return Optional.of(clazz.cast(sns()));
        case "sqs":
            return Optional.of(clazz.cast(sqs()));
        case "kinesis":
            return Optional.of(clazz.cast(kinesis()));
        case "republish":
            return Optional.of(clazz.cast(republish()));
        case "s3":
            return Optional.of(clazz.cast(s3()));
        case "firehose":
            return Optional.of(clazz.cast(firehose()));
        case "cloudwatchMetric":
            return Optional.of(clazz.cast(cloudwatchMetric()));
        case "cloudwatchAlarm":
            return Optional.of(clazz.cast(cloudwatchAlarm()));
        case "elasticsearch":
            return Optional.of(clazz.cast(elasticsearch()));
        case "salesforce":
            return Optional.of(clazz.cast(salesforce()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * Write to a DynamoDB table.
         * </p>
         * 
         * @param dynamoDB
         *        Write to a DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDB(DynamoDBAction dynamoDB);

        /**
         * <p>
         * Write to a DynamoDB table.
         * </p>
         * This is a convenience that creates an instance of the {@link DynamoDBAction.Builder} avoiding the need to
         * create one manually via {@link DynamoDBAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link DynamoDBAction.Builder#build()} is called immediately and its
         * result is passed to {@link #dynamoDB(DynamoDBAction)}.
         * 
         * @param dynamoDB
         *        a consumer that will call methods on {@link DynamoDBAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDB(DynamoDBAction)
         */
        default Builder dynamoDB(Consumer<DynamoDBAction.Builder> dynamoDB) {
            return dynamoDB(DynamoDBAction.builder().apply(dynamoDB).build());
        }

        /**
         * <p>
         * Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each
         * attribute in an MQTT message payload into a separate DynamoDB column.
         * </p>
         * 
         * @param dynamoDBv2
         *        Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each
         *        attribute in an MQTT message payload into a separate DynamoDB column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2);

        /**
         * <p>
         * Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each
         * attribute in an MQTT message payload into a separate DynamoDB column.
         * </p>
         * This is a convenience that creates an instance of the {@link DynamoDBv2Action.Builder} avoiding the need to
         * create one manually via {@link DynamoDBv2Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link DynamoDBv2Action.Builder#build()} is called immediately and its
         * result is passed to {@link #dynamoDBv2(DynamoDBv2Action)}.
         * 
         * @param dynamoDBv2
         *        a consumer that will call methods on {@link DynamoDBv2Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDBv2(DynamoDBv2Action)
         */
        default Builder dynamoDBv2(Consumer<DynamoDBv2Action.Builder> dynamoDBv2) {
            return dynamoDBv2(DynamoDBv2Action.builder().apply(dynamoDBv2).build());
        }

        /**
         * <p>
         * Invoke a Lambda function.
         * </p>
         * 
         * @param lambda
         *        Invoke a Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(LambdaAction lambda);

        /**
         * <p>
         * Invoke a Lambda function.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaAction.Builder} avoiding the need to
         * create one manually via {@link LambdaAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaAction.Builder#build()} is called immediately and its
         * result is passed to {@link #lambda(LambdaAction)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link LambdaAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(LambdaAction)
         */
        default Builder lambda(Consumer<LambdaAction.Builder> lambda) {
            return lambda(LambdaAction.builder().apply(lambda).build());
        }

        /**
         * <p>
         * Publish to an Amazon SNS topic.
         * </p>
         * 
         * @param sns
         *        Publish to an Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sns(SnsAction sns);

        /**
         * <p>
         * Publish to an Amazon SNS topic.
         * </p>
         * This is a convenience that creates an instance of the {@link SnsAction.Builder} avoiding the need to create
         * one manually via {@link SnsAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnsAction.Builder#build()} is called immediately and its result
         * is passed to {@link #sns(SnsAction)}.
         * 
         * @param sns
         *        a consumer that will call methods on {@link SnsAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sns(SnsAction)
         */
        default Builder sns(Consumer<SnsAction.Builder> sns) {
            return sns(SnsAction.builder().apply(sns).build());
        }

        /**
         * <p>
         * Publish to an Amazon SQS queue.
         * </p>
         * 
         * @param sqs
         *        Publish to an Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqs(SqsAction sqs);

        /**
         * <p>
         * Publish to an Amazon SQS queue.
         * </p>
         * This is a convenience that creates an instance of the {@link SqsAction.Builder} avoiding the need to create
         * one manually via {@link SqsAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link SqsAction.Builder#build()} is called immediately and its result
         * is passed to {@link #sqs(SqsAction)}.
         * 
         * @param sqs
         *        a consumer that will call methods on {@link SqsAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqs(SqsAction)
         */
        default Builder sqs(Consumer<SqsAction.Builder> sqs) {
            return sqs(SqsAction.builder().apply(sqs).build());
        }

        /**
         * <p>
         * Write data to an Amazon Kinesis stream.
         * </p>
         * 
         * @param kinesis
         *        Write data to an Amazon Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesis(KinesisAction kinesis);

        /**
         * <p>
         * Write data to an Amazon Kinesis stream.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisAction.Builder} avoiding the need to
         * create one manually via {@link KinesisAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisAction.Builder#build()} is called immediately and its
         * result is passed to {@link #kinesis(KinesisAction)}.
         * 
         * @param kinesis
         *        a consumer that will call methods on {@link KinesisAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesis(KinesisAction)
         */
        default Builder kinesis(Consumer<KinesisAction.Builder> kinesis) {
            return kinesis(KinesisAction.builder().apply(kinesis).build());
        }

        /**
         * <p>
         * Publish to another MQTT topic.
         * </p>
         * 
         * @param republish
         *        Publish to another MQTT topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder republish(RepublishAction republish);

        /**
         * <p>
         * Publish to another MQTT topic.
         * </p>
         * This is a convenience that creates an instance of the {@link RepublishAction.Builder} avoiding the need to
         * create one manually via {@link RepublishAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepublishAction.Builder#build()} is called immediately and its
         * result is passed to {@link #republish(RepublishAction)}.
         * 
         * @param republish
         *        a consumer that will call methods on {@link RepublishAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #republish(RepublishAction)
         */
        default Builder republish(Consumer<RepublishAction.Builder> republish) {
            return republish(RepublishAction.builder().apply(republish).build());
        }

        /**
         * <p>
         * Write to an Amazon S3 bucket.
         * </p>
         * 
         * @param s3
         *        Write to an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3Action s3);

        /**
         * <p>
         * Write to an Amazon S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Action.Builder} avoiding the need to create
         * one manually via {@link S3Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Action.Builder#build()} is called immediately and its result is
         * passed to {@link #s3(S3Action)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3Action)
         */
        default Builder s3(Consumer<S3Action.Builder> s3) {
            return s3(S3Action.builder().apply(s3).build());
        }

        /**
         * <p>
         * Write to an Amazon Kinesis Firehose stream.
         * </p>
         * 
         * @param firehose
         *        Write to an Amazon Kinesis Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehose(FirehoseAction firehose);

        /**
         * <p>
         * Write to an Amazon Kinesis Firehose stream.
         * </p>
         * This is a convenience that creates an instance of the {@link FirehoseAction.Builder} avoiding the need to
         * create one manually via {@link FirehoseAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirehoseAction.Builder#build()} is called immediately and its
         * result is passed to {@link #firehose(FirehoseAction)}.
         * 
         * @param firehose
         *        a consumer that will call methods on {@link FirehoseAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firehose(FirehoseAction)
         */
        default Builder firehose(Consumer<FirehoseAction.Builder> firehose) {
            return firehose(FirehoseAction.builder().apply(firehose).build());
        }

        /**
         * <p>
         * Capture a CloudWatch metric.
         * </p>
         * 
         * @param cloudwatchMetric
         *        Capture a CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchMetric(CloudwatchMetricAction cloudwatchMetric);

        /**
         * <p>
         * Capture a CloudWatch metric.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudwatchMetricAction.Builder} avoiding the
         * need to create one manually via {@link CloudwatchMetricAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudwatchMetricAction.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudwatchMetric(CloudwatchMetricAction)}.
         * 
         * @param cloudwatchMetric
         *        a consumer that will call methods on {@link CloudwatchMetricAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudwatchMetric(CloudwatchMetricAction)
         */
        default Builder cloudwatchMetric(Consumer<CloudwatchMetricAction.Builder> cloudwatchMetric) {
            return cloudwatchMetric(CloudwatchMetricAction.builder().apply(cloudwatchMetric).build());
        }

        /**
         * <p>
         * Change the state of a CloudWatch alarm.
         * </p>
         * 
         * @param cloudwatchAlarm
         *        Change the state of a CloudWatch alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchAlarm(CloudwatchAlarmAction cloudwatchAlarm);

        /**
         * <p>
         * Change the state of a CloudWatch alarm.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudwatchAlarmAction.Builder} avoiding the need
         * to create one manually via {@link CloudwatchAlarmAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudwatchAlarmAction.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudwatchAlarm(CloudwatchAlarmAction)}.
         * 
         * @param cloudwatchAlarm
         *        a consumer that will call methods on {@link CloudwatchAlarmAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudwatchAlarm(CloudwatchAlarmAction)
         */
        default Builder cloudwatchAlarm(Consumer<CloudwatchAlarmAction.Builder> cloudwatchAlarm) {
            return cloudwatchAlarm(CloudwatchAlarmAction.builder().apply(cloudwatchAlarm).build());
        }

        /**
         * <p>
         * Write data to an Amazon Elasticsearch Service domain.
         * </p>
         * 
         * @param elasticsearch
         *        Write data to an Amazon Elasticsearch Service domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearch(ElasticsearchAction elasticsearch);

        /**
         * <p>
         * Write data to an Amazon Elasticsearch Service domain.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchAction.Builder} avoiding the need
         * to create one manually via {@link ElasticsearchAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchAction.Builder#build()} is called immediately and
         * its result is passed to {@link #elasticsearch(ElasticsearchAction)}.
         * 
         * @param elasticsearch
         *        a consumer that will call methods on {@link ElasticsearchAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearch(ElasticsearchAction)
         */
        default Builder elasticsearch(Consumer<ElasticsearchAction.Builder> elasticsearch) {
            return elasticsearch(ElasticsearchAction.builder().apply(elasticsearch).build());
        }

        /**
         * <p>
         * Send a message to a Salesforce IoT Cloud Input Stream.
         * </p>
         * 
         * @param salesforce
         *        Send a message to a Salesforce IoT Cloud Input Stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforce(SalesforceAction salesforce);

        /**
         * <p>
         * Send a message to a Salesforce IoT Cloud Input Stream.
         * </p>
         * This is a convenience that creates an instance of the {@link SalesforceAction.Builder} avoiding the need to
         * create one manually via {@link SalesforceAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link SalesforceAction.Builder#build()} is called immediately and its
         * result is passed to {@link #salesforce(SalesforceAction)}.
         * 
         * @param salesforce
         *        a consumer that will call methods on {@link SalesforceAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforce(SalesforceAction)
         */
        default Builder salesforce(Consumer<SalesforceAction.Builder> salesforce) {
            return salesforce(SalesforceAction.builder().apply(salesforce).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DynamoDBAction dynamoDB;

        private DynamoDBv2Action dynamoDBv2;

        private LambdaAction lambda;

        private SnsAction sns;

        private SqsAction sqs;

        private KinesisAction kinesis;

        private RepublishAction republish;

        private S3Action s3;

        private FirehoseAction firehose;

        private CloudwatchMetricAction cloudwatchMetric;

        private CloudwatchAlarmAction cloudwatchAlarm;

        private ElasticsearchAction elasticsearch;

        private SalesforceAction salesforce;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            dynamoDB(model.dynamoDB);
            dynamoDBv2(model.dynamoDBv2);
            lambda(model.lambda);
            sns(model.sns);
            sqs(model.sqs);
            kinesis(model.kinesis);
            republish(model.republish);
            s3(model.s3);
            firehose(model.firehose);
            cloudwatchMetric(model.cloudwatchMetric);
            cloudwatchAlarm(model.cloudwatchAlarm);
            elasticsearch(model.elasticsearch);
            salesforce(model.salesforce);
        }

        public final DynamoDBAction.Builder getDynamoDB() {
            return dynamoDB != null ? dynamoDB.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDB(DynamoDBAction dynamoDB) {
            this.dynamoDB = dynamoDB;
            return this;
        }

        public final void setDynamoDB(DynamoDBAction.BuilderImpl dynamoDB) {
            this.dynamoDB = dynamoDB != null ? dynamoDB.build() : null;
        }

        public final DynamoDBv2Action.Builder getDynamoDBv2() {
            return dynamoDBv2 != null ? dynamoDBv2.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2;
            return this;
        }

        public final void setDynamoDBv2(DynamoDBv2Action.BuilderImpl dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2 != null ? dynamoDBv2.build() : null;
        }

        public final LambdaAction.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        @Override
        public final Builder lambda(LambdaAction lambda) {
            this.lambda = lambda;
            return this;
        }

        public final void setLambda(LambdaAction.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        public final SnsAction.Builder getSns() {
            return sns != null ? sns.toBuilder() : null;
        }

        @Override
        public final Builder sns(SnsAction sns) {
            this.sns = sns;
            return this;
        }

        public final void setSns(SnsAction.BuilderImpl sns) {
            this.sns = sns != null ? sns.build() : null;
        }

        public final SqsAction.Builder getSqs() {
            return sqs != null ? sqs.toBuilder() : null;
        }

        @Override
        public final Builder sqs(SqsAction sqs) {
            this.sqs = sqs;
            return this;
        }

        public final void setSqs(SqsAction.BuilderImpl sqs) {
            this.sqs = sqs != null ? sqs.build() : null;
        }

        public final KinesisAction.Builder getKinesis() {
            return kinesis != null ? kinesis.toBuilder() : null;
        }

        @Override
        public final Builder kinesis(KinesisAction kinesis) {
            this.kinesis = kinesis;
            return this;
        }

        public final void setKinesis(KinesisAction.BuilderImpl kinesis) {
            this.kinesis = kinesis != null ? kinesis.build() : null;
        }

        public final RepublishAction.Builder getRepublish() {
            return republish != null ? republish.toBuilder() : null;
        }

        @Override
        public final Builder republish(RepublishAction republish) {
            this.republish = republish;
            return this;
        }

        public final void setRepublish(RepublishAction.BuilderImpl republish) {
            this.republish = republish != null ? republish.build() : null;
        }

        public final S3Action.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        @Override
        public final Builder s3(S3Action s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3Action.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        public final FirehoseAction.Builder getFirehose() {
            return firehose != null ? firehose.toBuilder() : null;
        }

        @Override
        public final Builder firehose(FirehoseAction firehose) {
            this.firehose = firehose;
            return this;
        }

        public final void setFirehose(FirehoseAction.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        public final CloudwatchMetricAction.Builder getCloudwatchMetric() {
            return cloudwatchMetric != null ? cloudwatchMetric.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchMetric(CloudwatchMetricAction cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric;
            return this;
        }

        public final void setCloudwatchMetric(CloudwatchMetricAction.BuilderImpl cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric != null ? cloudwatchMetric.build() : null;
        }

        public final CloudwatchAlarmAction.Builder getCloudwatchAlarm() {
            return cloudwatchAlarm != null ? cloudwatchAlarm.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchAlarm(CloudwatchAlarmAction cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm;
            return this;
        }

        public final void setCloudwatchAlarm(CloudwatchAlarmAction.BuilderImpl cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm != null ? cloudwatchAlarm.build() : null;
        }

        public final ElasticsearchAction.Builder getElasticsearch() {
            return elasticsearch != null ? elasticsearch.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearch(ElasticsearchAction elasticsearch) {
            this.elasticsearch = elasticsearch;
            return this;
        }

        public final void setElasticsearch(ElasticsearchAction.BuilderImpl elasticsearch) {
            this.elasticsearch = elasticsearch != null ? elasticsearch.build() : null;
        }

        public final SalesforceAction.Builder getSalesforce() {
            return salesforce != null ? salesforce.toBuilder() : null;
        }

        @Override
        public final Builder salesforce(SalesforceAction salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final void setSalesforce(SalesforceAction.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        @Override
        public Action build() {
            return new Action(this);
        }
    }
}
