/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the Publish operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PublishRequest extends AmazonWebServiceRequest implements ToCopyableBuilder<PublishRequest.Builder, PublishRequest> {
    private final String topic;

    private final Integer qos;

    private final ByteBuffer payload;

    private PublishRequest(BuilderImpl builder) {
        this.topic = builder.topic;
        this.qos = builder.qos;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The name of the MQTT topic.
     * </p>
     * 
     * @return The name of the MQTT topic.
     */
    public String topic() {
        return topic;
    }

    /**
     * <p>
     * The Quality of Service (QoS) level.
     * </p>
     * 
     * @return The Quality of Service (QoS) level.
     */
    public Integer qos() {
        return qos;
    }

    /**
     * <p>
     * The state information, in JSON format.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The state information, in JSON format.
     */
    public ByteBuffer payload() {
        return payload == null ? null : payload.asReadOnlyBuffer();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topic() == null) ? 0 : topic().hashCode());
        hashCode = 31 * hashCode + ((qos() == null) ? 0 : qos().hashCode());
        hashCode = 31 * hashCode + ((payload() == null) ? 0 : payload().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest) obj;
        if (other.topic() == null ^ this.topic() == null) {
            return false;
        }
        if (other.topic() != null && !other.topic().equals(this.topic())) {
            return false;
        }
        if (other.qos() == null ^ this.qos() == null) {
            return false;
        }
        if (other.qos() != null && !other.qos().equals(this.qos())) {
            return false;
        }
        if (other.payload() == null ^ this.payload() == null) {
            return false;
        }
        if (other.payload() != null && !other.payload().equals(this.payload())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (topic() != null) {
            sb.append("Topic: ").append(topic()).append(",");
        }
        if (qos() != null) {
            sb.append("Qos: ").append(qos()).append(",");
        }
        if (payload() != null) {
            sb.append("Payload: ").append(payload()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PublishRequest> {
        /**
         * <p>
         * The name of the MQTT topic.
         * </p>
         * 
         * @param topic
         *        The name of the MQTT topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);

        /**
         * <p>
         * The Quality of Service (QoS) level.
         * </p>
         * 
         * @param qos
         *        The Quality of Service (QoS) level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qos(Integer qos);

        /**
         * <p>
         * The state information, in JSON format.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param payload
         *        The state information, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(ByteBuffer payload);
    }

    private static final class BuilderImpl implements Builder {
        private String topic;

        private Integer qos;

        private ByteBuffer payload;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishRequest model) {
            setTopic(model.topic);
            setQos(model.qos);
            setPayload(model.payload);
        }

        public final String getTopic() {
            return topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public final Integer getQos() {
            return qos;
        }

        @Override
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        public final ByteBuffer getPayload() {
            return payload;
        }

        @Override
        public final Builder payload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy(payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy(payload);
        }

        @Override
        public PublishRequest build() {
            return new PublishRequest(this);
        }
    }
}
