/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the UpdateCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateCertificateRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateCertificateRequest.Builder, UpdateCertificateRequest> {
    private final String certificateId;

    private final String newStatus;

    private UpdateCertificateRequest(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.newStatus = builder.newStatus;
    }

    /**
     * <p>
     * The ID of the certificate.
     * </p>
     * 
     * @return The ID of the certificate.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The new status.
     * </p>
     * <p>
     * <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown. PENDING_TRANSFER is
     * a status used internally by AWS IoT. It is not intended for developer use.
     * </p>
     * <p>
     * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * </p>
     * 
     * @return The new status.</p>
     *         <p>
     *         <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown.
     *         PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.
     *         </p>
     *         <p>
     *         <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * @see CertificateStatus
     */
    public String newStatus() {
        return newStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificateId() == null) ? 0 : certificateId().hashCode());
        hashCode = 31 * hashCode + ((newStatus() == null) ? 0 : newStatus().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCertificateRequest)) {
            return false;
        }
        UpdateCertificateRequest other = (UpdateCertificateRequest) obj;
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.newStatus() == null ^ this.newStatus() == null) {
            return false;
        }
        if (other.newStatus() != null && !other.newStatus().equals(this.newStatus())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (certificateId() != null) {
            sb.append("CertificateId: ").append(certificateId()).append(",");
        }
        if (newStatus() != null) {
            sb.append("NewStatus: ").append(newStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateCertificateRequest> {
        /**
         * <p>
         * The ID of the certificate.
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The new status.
         * </p>
         * <p>
         * <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown.
         * PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.
         * </p>
         * <p>
         * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param newStatus
         *        The new status.</p>
         *        <p>
         *        <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown.
         *        PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.
         *        </p>
         *        <p>
         *        <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder newStatus(String newStatus);

        /**
         * <p>
         * The new status.
         * </p>
         * <p>
         * <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown.
         * PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.
         * </p>
         * <p>
         * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param newStatus
         *        The new status.</p>
         *        <p>
         *        <b>Note:</b> Setting the status to PENDING_TRANSFER will result in an exception being thrown.
         *        PENDING_TRANSFER is a status used internally by AWS IoT. It is not intended for developer use.
         *        </p>
         *        <p>
         *        <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder newStatus(CertificateStatus newStatus);
    }

    private static final class BuilderImpl implements Builder {
        private String certificateId;

        private String newStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCertificateRequest model) {
            setCertificateId(model.certificateId);
            setNewStatus(model.newStatus);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getNewStatus() {
            return newStatus;
        }

        @Override
        public final Builder newStatus(String newStatus) {
            this.newStatus = newStatus;
            return this;
        }

        @Override
        public final Builder newStatus(CertificateStatus newStatus) {
            this.newStatus(newStatus.toString());
            return this;
        }

        public final void setNewStatus(String newStatus) {
            this.newStatus = newStatus;
        }

        @Override
        public UpdateCertificateRequest build() {
            return new UpdateCertificateRequest(this);
        }
    }
}
