/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the TransferCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TransferCertificateResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<TransferCertificateResponse.Builder, TransferCertificateResponse> {
    private final String transferredCertificateArn;

    private TransferCertificateResponse(BuilderImpl builder) {
        this.transferredCertificateArn = builder.transferredCertificateArn;
    }

    /**
     * <p>
     * The ARN of the certificate.
     * </p>
     * 
     * @return The ARN of the certificate.
     */
    public String transferredCertificateArn() {
        return transferredCertificateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((transferredCertificateArn() == null) ? 0 : transferredCertificateArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferCertificateResponse)) {
            return false;
        }
        TransferCertificateResponse other = (TransferCertificateResponse) obj;
        if (other.transferredCertificateArn() == null ^ this.transferredCertificateArn() == null) {
            return false;
        }
        if (other.transferredCertificateArn() != null
                && !other.transferredCertificateArn().equals(this.transferredCertificateArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (transferredCertificateArn() != null) {
            sb.append("TransferredCertificateArn: ").append(transferredCertificateArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TransferCertificateResponse> {
        /**
         * <p>
         * The ARN of the certificate.
         * </p>
         * 
         * @param transferredCertificateArn
         *        The ARN of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferredCertificateArn(String transferredCertificateArn);
    }

    private static final class BuilderImpl implements Builder {
        private String transferredCertificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferCertificateResponse model) {
            setTransferredCertificateArn(model.transferredCertificateArn);
        }

        public final String getTransferredCertificateArn() {
            return transferredCertificateArn;
        }

        @Override
        public final Builder transferredCertificateArn(String transferredCertificateArn) {
            this.transferredCertificateArn = transferredCertificateArn;
            return this;
        }

        public final void setTransferredCertificateArn(String transferredCertificateArn) {
            this.transferredCertificateArn = transferredCertificateArn;
        }

        @Override
        public TransferCertificateResponse build() {
            return new TransferCertificateResponse(this);
        }
    }
}
