/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the ListThings operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListThingsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListThingsRequest.Builder, ListThingsRequest> {
    private final String nextToken;

    private final Integer maxResults;

    private final String attributeName;

    private final String attributeValue;

    private final String thingTypeName;

    private ListThingsRequest(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
        this.thingTypeName = builder.thingTypeName;
    }

    /**
     * <p>
     * The token for the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in this operation.
     * </p>
     * 
     * @return The maximum number of results to return in this operation.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The attribute name used to search for things.
     * </p>
     * 
     * @return The attribute name used to search for things.
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The attribute value used to search for things.
     * </p>
     * 
     * @return The attribute value used to search for things.
     */
    public String attributeValue() {
        return attributeValue;
    }

    /**
     * <p>
     * The name of the thing type used to search for things.
     * </p>
     * 
     * @return The name of the thing type used to search for things.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((attributeName() == null) ? 0 : attributeName().hashCode());
        hashCode = 31 * hashCode + ((attributeValue() == null) ? 0 : attributeValue().hashCode());
        hashCode = 31 * hashCode + ((thingTypeName() == null) ? 0 : thingTypeName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingsRequest)) {
            return false;
        }
        ListThingsRequest other = (ListThingsRequest) obj;
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        if (other.attributeValue() == null ^ this.attributeValue() == null) {
            return false;
        }
        if (other.attributeValue() != null && !other.attributeValue().equals(this.attributeValue())) {
            return false;
        }
        if (other.thingTypeName() == null ^ this.thingTypeName() == null) {
            return false;
        }
        if (other.thingTypeName() != null && !other.thingTypeName().equals(this.thingTypeName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (attributeName() != null) {
            sb.append("AttributeName: ").append(attributeName()).append(",");
        }
        if (attributeValue() != null) {
            sb.append("AttributeValue: ").append(attributeValue()).append(",");
        }
        if (thingTypeName() != null) {
            sb.append("ThingTypeName: ").append(thingTypeName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListThingsRequest> {
        /**
         * <p>
         * The token for the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in this operation.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The attribute name used to search for things.
         * </p>
         * 
         * @param attributeName
         *        The attribute name used to search for things.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The attribute value used to search for things.
         * </p>
         * 
         * @param attributeValue
         *        The attribute value used to search for things.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);

        /**
         * <p>
         * The name of the thing type used to search for things.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type used to search for things.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);
    }

    private static final class BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String attributeName;

        private String attributeValue;

        private String thingTypeName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingsRequest model) {
            setNextToken(model.nextToken);
            setMaxResults(model.maxResults);
            setAttributeName(model.attributeName);
            setAttributeValue(model.attributeValue);
            setThingTypeName(model.thingTypeName);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        @Override
        public ListThingsRequest build() {
            return new ListThingsRequest(this);
        }
    }
}
