/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the ListThingTypes operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListThingTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListThingTypesResponse.Builder, ListThingTypesResponse> {
    private final List<ThingTypeDefinition> thingTypes;

    private final String nextToken;

    private ListThingTypesResponse(BuilderImpl builder) {
        this.thingTypes = builder.thingTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The thing types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The thing types.
     */
    public List<ThingTypeDefinition> thingTypes() {
        return thingTypes;
    }

    /**
     * <p>
     * The token for the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((thingTypes() == null) ? 0 : thingTypes().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingTypesResponse)) {
            return false;
        }
        ListThingTypesResponse other = (ListThingTypesResponse) obj;
        if (other.thingTypes() == null ^ this.thingTypes() == null) {
            return false;
        }
        if (other.thingTypes() != null && !other.thingTypes().equals(this.thingTypes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (thingTypes() != null) {
            sb.append("ThingTypes: ").append(thingTypes()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListThingTypesResponse> {
        /**
         * <p>
         * The thing types.
         * </p>
         * 
         * @param thingTypes
         *        The thing types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypes(Collection<ThingTypeDefinition> thingTypes);

        /**
         * <p>
         * The thing types.
         * </p>
         * 
         * @param thingTypes
         *        The thing types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypes(ThingTypeDefinition... thingTypes);

        /**
         * <p>
         * The token for the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ThingTypeDefinition> thingTypes;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingTypesResponse model) {
            setThingTypes(model.thingTypes);
            setNextToken(model.nextToken);
        }

        public final Collection<ThingTypeDefinition> getThingTypes() {
            return thingTypes;
        }

        @Override
        public final Builder thingTypes(Collection<ThingTypeDefinition> thingTypes) {
            this.thingTypes = ThingTypeListCopier.copy(thingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingTypes(ThingTypeDefinition... thingTypes) {
            thingTypes(Arrays.asList(thingTypes));
            return this;
        }

        public final void setThingTypes(Collection<ThingTypeDefinition> thingTypes) {
            this.thingTypes = ThingTypeListCopier.copy(thingTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingTypesResponse build() {
            return new ListThingTypesResponse(this);
        }
    }
}
