/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.KeyPairMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a key pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KeyPair implements StructuredPojo, ToCopyableBuilder<KeyPair.Builder, KeyPair> {
    private final String publicKey;

    private final String privateKey;

    private KeyPair(BuilderImpl builder) {
        this.publicKey = builder.publicKey;
        this.privateKey = builder.privateKey;
    }

    /**
     * <p>
     * The public key.
     * </p>
     * 
     * @return The public key.
     */
    public String publicKey() {
        return publicKey;
    }

    /**
     * <p>
     * The private key.
     * </p>
     * 
     * @return The private key.
     */
    public String privateKey() {
        return privateKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((publicKey() == null) ? 0 : publicKey().hashCode());
        hashCode = 31 * hashCode + ((privateKey() == null) ? 0 : privateKey().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair) obj;
        if (other.publicKey() == null ^ this.publicKey() == null) {
            return false;
        }
        if (other.publicKey() != null && !other.publicKey().equals(this.publicKey())) {
            return false;
        }
        if (other.privateKey() == null ^ this.privateKey() == null) {
            return false;
        }
        if (other.privateKey() != null && !other.privateKey().equals(this.privateKey())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (publicKey() != null) {
            sb.append("PublicKey: ").append(publicKey()).append(",");
        }
        if (privateKey() != null) {
            sb.append("PrivateKey: ").append(privateKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyPairMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KeyPair> {
        /**
         * <p>
         * The public key.
         * </p>
         * 
         * @param publicKey
         *        The public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(String publicKey);

        /**
         * <p>
         * The private key.
         * </p>
         * 
         * @param privateKey
         *        The private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);
    }

    private static final class BuilderImpl implements Builder {
        private String publicKey;

        private String privateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPair model) {
            setPublicKey(model.publicKey);
            setPrivateKey(model.privateKey);
        }

        public final String getPublicKey() {
            return publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public KeyPair build() {
            return new KeyPair(this);
        }
    }
}
