/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.DynamoDBv2ActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to write to a DynamoDB table.
 * </p>
 * <p>
 * This DynamoDB action writes each attribute in the message payload into it's own column in the DynamoDB table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DynamoDBv2Action implements StructuredPojo, ToCopyableBuilder<DynamoDBv2Action.Builder, DynamoDBv2Action> {
    private final String roleArn;

    private final PutItemInput putItem;

    private DynamoDBv2Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.putItem = builder.putItem;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access to the DynamoDB table.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access to the DynamoDB table.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Specifies the DynamoDB table to which the message data will be written. For example:
     * </p>
     * <p>
     * <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
     * </p>
     * <p>
     * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
     * </p>
     * 
     * @return Specifies the DynamoDB table to which the message data will be written. For example:</p>
     *         <p>
     *         <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
     *         </p>
     *         <p>
     *         Each attribute in the message payload will be written to a separate column in the DynamoDB database.
     */
    public PutItemInput putItem() {
        return putItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((roleArn() == null) ? 0 : roleArn().hashCode());
        hashCode = 31 * hashCode + ((putItem() == null) ? 0 : putItem().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBv2Action)) {
            return false;
        }
        DynamoDBv2Action other = (DynamoDBv2Action) obj;
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.putItem() == null ^ this.putItem() == null) {
            return false;
        }
        if (other.putItem() != null && !other.putItem().equals(this.putItem())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (putItem() != null) {
            sb.append("PutItem: ").append(putItem()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DynamoDBv2ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DynamoDBv2Action> {
        /**
         * <p>
         * The ARN of the IAM role that grants access to the DynamoDB table.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access to the DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Specifies the DynamoDB table to which the message data will be written. For example:
         * </p>
         * <p>
         * <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
         * </p>
         * <p>
         * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
         * </p>
         * 
         * @param putItem
         *        Specifies the DynamoDB table to which the message data will be written. For example:</p>
         *        <p>
         *        <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
         *        </p>
         *        <p>
         *        Each attribute in the message payload will be written to a separate column in the DynamoDB database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder putItem(PutItemInput putItem);
    }

    private static final class BuilderImpl implements Builder {
        private String roleArn;

        private PutItemInput putItem;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBv2Action model) {
            setRoleArn(model.roleArn);
            setPutItem(model.putItem);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final PutItemInput getPutItem() {
            return putItem;
        }

        @Override
        public final Builder putItem(PutItemInput putItem) {
            this.putItem = putItem;
            return this;
        }

        public final void setPutItem(PutItemInput putItem) {
            this.putItem = putItem;
        }

        @Override
        public DynamoDBv2Action build() {
            return new DynamoDBv2Action(this);
        }
    }
}
