/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the DescribeCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCertificateResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeCertificateResponse.Builder, DescribeCertificateResponse> {
    private final CertificateDescription certificateDescription;

    private DescribeCertificateResponse(BuilderImpl builder) {
        this.certificateDescription = builder.certificateDescription;
    }

    /**
     * <p>
     * The description of the certificate.
     * </p>
     * 
     * @return The description of the certificate.
     */
    public CertificateDescription certificateDescription() {
        return certificateDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificateDescription() == null) ? 0 : certificateDescription().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCertificateResponse)) {
            return false;
        }
        DescribeCertificateResponse other = (DescribeCertificateResponse) obj;
        if (other.certificateDescription() == null ^ this.certificateDescription() == null) {
            return false;
        }
        if (other.certificateDescription() != null && !other.certificateDescription().equals(this.certificateDescription())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (certificateDescription() != null) {
            sb.append("CertificateDescription: ").append(certificateDescription()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeCertificateResponse> {
        /**
         * <p>
         * The description of the certificate.
         * </p>
         * 
         * @param certificateDescription
         *        The description of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateDescription(CertificateDescription certificateDescription);
    }

    private static final class BuilderImpl implements Builder {
        private CertificateDescription certificateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCertificateResponse model) {
            setCertificateDescription(model.certificateDescription);
        }

        public final CertificateDescription getCertificateDescription() {
            return certificateDescription;
        }

        @Override
        public final Builder certificateDescription(CertificateDescription certificateDescription) {
            this.certificateDescription = certificateDescription;
            return this;
        }

        public final void setCertificateDescription(CertificateDescription certificateDescription) {
            this.certificateDescription = certificateDescription;
        }

        @Override
        public DescribeCertificateResponse build() {
            return new DescribeCertificateResponse(this);
        }
    }
}
