/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the DescribeCACertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCACertificateResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeCACertificateResponse.Builder, DescribeCACertificateResponse> {
    private final CACertificateDescription certificateDescription;

    private DescribeCACertificateResponse(BuilderImpl builder) {
        this.certificateDescription = builder.certificateDescription;
    }

    /**
     * <p>
     * The CA certificate description.
     * </p>
     * 
     * @return The CA certificate description.
     */
    public CACertificateDescription certificateDescription() {
        return certificateDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificateDescription() == null) ? 0 : certificateDescription().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCACertificateResponse)) {
            return false;
        }
        DescribeCACertificateResponse other = (DescribeCACertificateResponse) obj;
        if (other.certificateDescription() == null ^ this.certificateDescription() == null) {
            return false;
        }
        if (other.certificateDescription() != null && !other.certificateDescription().equals(this.certificateDescription())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (certificateDescription() != null) {
            sb.append("CertificateDescription: ").append(certificateDescription()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeCACertificateResponse> {
        /**
         * <p>
         * The CA certificate description.
         * </p>
         * 
         * @param certificateDescription
         *        The CA certificate description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateDescription(CACertificateDescription certificateDescription);
    }

    private static final class BuilderImpl implements Builder {
        private CACertificateDescription certificateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCACertificateResponse model) {
            setCertificateDescription(model.certificateDescription);
        }

        public final CACertificateDescription getCertificateDescription() {
            return certificateDescription;
        }

        @Override
        public final Builder certificateDescription(CACertificateDescription certificateDescription) {
            this.certificateDescription = certificateDescription;
            return this;
        }

        public final void setCertificateDescription(CACertificateDescription certificateDescription) {
            this.certificateDescription = certificateDescription;
        }

        @Override
        public DescribeCACertificateResponse build() {
            return new DescribeCACertificateResponse(this);
        }
    }
}
