/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CACertificateDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a CA certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CACertificateDescription implements StructuredPojo,
        ToCopyableBuilder<CACertificateDescription.Builder, CACertificateDescription> {
    private final String certificateArn;

    private final String certificateId;

    private final String status;

    private final String certificatePem;

    private final String ownedBy;

    private final Instant creationDate;

    private final String autoRegistrationStatus;

    private CACertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.creationDate = builder.creationDate;
        this.autoRegistrationStatus = builder.autoRegistrationStatus;
    }

    /**
     * <p>
     * The CA certificate ARN.
     * </p>
     * 
     * @return The CA certificate ARN.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The CA certificate ID.
     * </p>
     * 
     * @return The CA certificate ID.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The status of a CA certificate.
     * </p>
     * 
     * @return The status of a CA certificate.
     * @see CACertificateStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The CA certificate data, in PEM format.
     * </p>
     * 
     * @return The CA certificate data, in PEM format.
     */
    public String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The owner of the CA certificate.
     * </p>
     * 
     * @return The owner of the CA certificate.
     */
    public String ownedBy() {
        return ownedBy;
    }

    /**
     * <p>
     * The date the CA certificate was created.
     * </p>
     * 
     * @return The date the CA certificate was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE" and
     * "DISABLE"
     * </p>
     * 
     * @return Whether the CA certificate configured for auto registration of device certificates. Valid values are
     *         "ENABLE" and "DISABLE"
     * @see AutoRegistrationStatus
     */
    public String autoRegistrationStatus() {
        return autoRegistrationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificateArn() == null) ? 0 : certificateArn().hashCode());
        hashCode = 31 * hashCode + ((certificateId() == null) ? 0 : certificateId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((certificatePem() == null) ? 0 : certificatePem().hashCode());
        hashCode = 31 * hashCode + ((ownedBy() == null) ? 0 : ownedBy().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((autoRegistrationStatus() == null) ? 0 : autoRegistrationStatus().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CACertificateDescription)) {
            return false;
        }
        CACertificateDescription other = (CACertificateDescription) obj;
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        if (other.certificateArn() != null && !other.certificateArn().equals(this.certificateArn())) {
            return false;
        }
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.certificatePem() == null ^ this.certificatePem() == null) {
            return false;
        }
        if (other.certificatePem() != null && !other.certificatePem().equals(this.certificatePem())) {
            return false;
        }
        if (other.ownedBy() == null ^ this.ownedBy() == null) {
            return false;
        }
        if (other.ownedBy() != null && !other.ownedBy().equals(this.ownedBy())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.autoRegistrationStatus() == null ^ this.autoRegistrationStatus() == null) {
            return false;
        }
        if (other.autoRegistrationStatus() != null && !other.autoRegistrationStatus().equals(this.autoRegistrationStatus())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (certificateArn() != null) {
            sb.append("CertificateArn: ").append(certificateArn()).append(",");
        }
        if (certificateId() != null) {
            sb.append("CertificateId: ").append(certificateId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (certificatePem() != null) {
            sb.append("CertificatePem: ").append(certificatePem()).append(",");
        }
        if (ownedBy() != null) {
            sb.append("OwnedBy: ").append(ownedBy()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (autoRegistrationStatus() != null) {
            sb.append("AutoRegistrationStatus: ").append(autoRegistrationStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CACertificateDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CACertificateDescription> {
        /**
         * <p>
         * The CA certificate ARN.
         * </p>
         * 
         * @param certificateArn
         *        The CA certificate ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The CA certificate ID.
         * </p>
         * 
         * @param certificateId
         *        The CA certificate ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The status of a CA certificate.
         * </p>
         * 
         * @param status
         *        The status of a CA certificate.
         * @see CACertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a CA certificate.
         * </p>
         * 
         * @param status
         *        The status of a CA certificate.
         * @see CACertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder status(CACertificateStatus status);

        /**
         * <p>
         * The CA certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The CA certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The owner of the CA certificate.
         * </p>
         * 
         * @param ownedBy
         *        The owner of the CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownedBy(String ownedBy);

        /**
         * <p>
         * The date the CA certificate was created.
         * </p>
         * 
         * @param creationDate
         *        The date the CA certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE"
         * and "DISABLE"
         * </p>
         * 
         * @param autoRegistrationStatus
         *        Whether the CA certificate configured for auto registration of device certificates. Valid values are
         *        "ENABLE" and "DISABLE"
         * @see AutoRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRegistrationStatus
         */
        Builder autoRegistrationStatus(String autoRegistrationStatus);

        /**
         * <p>
         * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE"
         * and "DISABLE"
         * </p>
         * 
         * @param autoRegistrationStatus
         *        Whether the CA certificate configured for auto registration of device certificates. Valid values are
         *        "ENABLE" and "DISABLE"
         * @see AutoRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRegistrationStatus
         */
        Builder autoRegistrationStatus(AutoRegistrationStatus autoRegistrationStatus);
    }

    private static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String status;

        private String certificatePem;

        private String ownedBy;

        private Instant creationDate;

        private String autoRegistrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CACertificateDescription model) {
            setCertificateArn(model.certificateArn);
            setCertificateId(model.certificateId);
            setStatus(model.status);
            setCertificatePem(model.certificatePem);
            setOwnedBy(model.ownedBy);
            setCreationDate(model.creationDate);
            setAutoRegistrationStatus(model.autoRegistrationStatus);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CACertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getOwnedBy() {
            return ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getAutoRegistrationStatus() {
            return autoRegistrationStatus;
        }

        @Override
        public final Builder autoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
            return this;
        }

        @Override
        public final Builder autoRegistrationStatus(AutoRegistrationStatus autoRegistrationStatus) {
            this.autoRegistrationStatus(autoRegistrationStatus.toString());
            return this;
        }

        public final void setAutoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
        }

        @Override
        public CACertificateDescription build() {
            return new CACertificateDescription(this);
        }
    }
}
