/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.iot.model.CACertificate;
import software.amazon.awssdk.services.iot.model.CACertificatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCACertificatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListCACertificatesResponse> {
    private final List<CACertificate> certificates;
    private final String nextMarker;

    private ListCACertificatesResponse(BuilderImpl builder) {
        this.certificates = builder.certificates;
        this.nextMarker = builder.nextMarker;
    }

    public List<CACertificate> certificates() {
        return this.certificates;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificates() == null ? 0 : this.certificates().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCACertificatesResponse)) {
            return false;
        }
        ListCACertificatesResponse other = (ListCACertificatesResponse)((Object)obj);
        if (other.certificates() == null ^ this.certificates() == null) {
            return false;
        }
        if (other.certificates() != null && !other.certificates().equals(this.certificates())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificates() != null) {
            sb.append("Certificates: ").append(this.certificates()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<CACertificate> certificates;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCACertificatesResponse model) {
            this.setCertificates(model.certificates);
            this.setNextMarker(model.nextMarker);
        }

        public final Collection<CACertificate> getCertificates() {
            return this.certificates;
        }

        @Override
        public final Builder certificates(Collection<CACertificate> certificates) {
            this.certificates = CACertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(CACertificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        public final void setCertificates(Collection<CACertificate> certificates) {
            this.certificates = CACertificatesCopier.copy(certificates);
        }

        @SafeVarargs
        public final void setCertificates(CACertificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public ListCACertificatesResponse build() {
            return new ListCACertificatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCACertificatesResponse> {
        public Builder certificates(Collection<CACertificate> var1);

        public Builder certificates(CACertificate ... var1);

        public Builder nextMarker(String var1);
    }
}

