/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.FirehoseActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FirehoseAction
implements StructuredPojo,
ToCopyableBuilder<Builder, FirehoseAction> {
    private final String roleArn;
    private final String deliveryStreamName;
    private final String separator;

    private FirehoseAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.deliveryStreamName = builder.deliveryStreamName;
        this.separator = builder.separator;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public String separator() {
        return this.separator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.deliveryStreamName() == null ? 0 : this.deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + (this.separator() == null ? 0 : this.separator().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirehoseAction)) {
            return false;
        }
        FirehoseAction other = (FirehoseAction)obj;
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.separator() == null ^ this.separator() == null) {
            return false;
        }
        return other.separator() == null || other.separator().equals(this.separator());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(this.deliveryStreamName()).append(",");
        }
        if (this.separator() != null) {
            sb.append("Separator: ").append(this.separator()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FirehoseActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String deliveryStreamName;
        private String separator;

        private BuilderImpl() {
        }

        private BuilderImpl(FirehoseAction model) {
            this.setRoleArn(model.roleArn);
            this.setDeliveryStreamName(model.deliveryStreamName);
            this.setSeparator(model.separator);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getSeparator() {
            return this.separator;
        }

        @Override
        public final Builder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public final void setSeparator(String separator) {
            this.separator = separator;
        }

        public FirehoseAction build() {
            return new FirehoseAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FirehoseAction> {
        public Builder roleArn(String var1);

        public Builder deliveryStreamName(String var1);

        public Builder separator(String var1);
    }
}

