/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the TransferCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransferCertificateRequest extends IotRequest implements
        ToCopyableBuilder<TransferCertificateRequest.Builder, TransferCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransferCertificateRequest::certificateId)).setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("certificateId").build()).build();

    private static final SdkField<String> TARGET_AWS_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransferCertificateRequest::targetAwsAccount)).setter(setter(Builder::targetAwsAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetAwsAccount").build())
            .build();

    private static final SdkField<String> TRANSFER_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransferCertificateRequest::transferMessage)).setter(setter(Builder::transferMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD,
            TARGET_AWS_ACCOUNT_FIELD, TRANSFER_MESSAGE_FIELD));

    private final String certificateId;

    private final String targetAwsAccount;

    private final String transferMessage;

    private TransferCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.targetAwsAccount = builder.targetAwsAccount;
        this.transferMessage = builder.transferMessage;
    }

    /**
     * <p>
     * The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
     * </p>
     * 
     * @return The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The AWS account.
     * </p>
     * 
     * @return The AWS account.
     */
    public String targetAwsAccount() {
        return targetAwsAccount;
    }

    /**
     * <p>
     * The transfer message.
     * </p>
     * 
     * @return The transfer message.
     */
    public String transferMessage() {
        return transferMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(targetAwsAccount());
        hashCode = 31 * hashCode + Objects.hashCode(transferMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferCertificateRequest)) {
            return false;
        }
        TransferCertificateRequest other = (TransferCertificateRequest) obj;
        return Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(targetAwsAccount(), other.targetAwsAccount())
                && Objects.equals(transferMessage(), other.transferMessage());
    }

    @Override
    public String toString() {
        return ToString.builder("TransferCertificateRequest").add("CertificateId", certificateId())
                .add("TargetAwsAccount", targetAwsAccount()).add("TransferMessage", transferMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "targetAwsAccount":
            return Optional.ofNullable(clazz.cast(targetAwsAccount()));
        case "transferMessage":
            return Optional.ofNullable(clazz.cast(transferMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransferCertificateRequest, T> g) {
        return obj -> g.apply((TransferCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, TransferCertificateRequest> {
        /**
         * <p>
         * The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The AWS account.
         * </p>
         * 
         * @param targetAwsAccount
         *        The AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAwsAccount(String targetAwsAccount);

        /**
         * <p>
         * The transfer message.
         * </p>
         * 
         * @param transferMessage
         *        The transfer message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferMessage(String transferMessage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String certificateId;

        private String targetAwsAccount;

        private String transferMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferCertificateRequest model) {
            super(model);
            certificateId(model.certificateId);
            targetAwsAccount(model.targetAwsAccount);
            transferMessage(model.transferMessage);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getTargetAwsAccount() {
            return targetAwsAccount;
        }

        @Override
        public final Builder targetAwsAccount(String targetAwsAccount) {
            this.targetAwsAccount = targetAwsAccount;
            return this;
        }

        public final void setTargetAwsAccount(String targetAwsAccount) {
            this.targetAwsAccount = targetAwsAccount;
        }

        public final String getTransferMessage() {
            return transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TransferCertificateRequest build() {
            return new TransferCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
