/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountAuditConfigurationResponse extends IotResponse implements
        ToCopyableBuilder<DescribeAccountAuditConfigurationResponse.Builder, DescribeAccountAuditConfigurationResponse> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAccountAuditConfigurationResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, AuditNotificationTarget>> AUDIT_NOTIFICATION_TARGET_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, AuditNotificationTarget>> builder(MarshallingType.MAP)
            .getter(getter(DescribeAccountAuditConfigurationResponse::auditNotificationTargetConfigurationsAsStrings))
            .setter(setter(Builder::auditNotificationTargetConfigurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("auditNotificationTargetConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AuditNotificationTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditNotificationTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AuditCheckConfiguration>> AUDIT_CHECK_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, AuditCheckConfiguration>> builder(MarshallingType.MAP)
            .getter(getter(DescribeAccountAuditConfigurationResponse::auditCheckConfigurations))
            .setter(setter(Builder::auditCheckConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditCheckConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AuditCheckConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditCheckConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            AUDIT_NOTIFICATION_TARGET_CONFIGURATIONS_FIELD, AUDIT_CHECK_CONFIGURATIONS_FIELD));

    private final String roleArn;

    private final Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations;

    private final Map<String, AuditCheckConfiguration> auditCheckConfigurations;

    private DescribeAccountAuditConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.auditNotificationTargetConfigurations = builder.auditNotificationTargetConfigurations;
        this.auditCheckConfigurations = builder.auditCheckConfigurations;
    }

    /**
     * <p>
     * The ARN of the role that grants permission to AWS IoT to access information about your devices, policies,
     * certificates and other items as necessary when performing an audit.
     * </p>
     * <p>
     * On the first call to <code>UpdateAccountAuditConfiguration</code> this parameter is required.
     * </p>
     * 
     * @return The ARN of the role that grants permission to AWS IoT to access information about your devices, policies,
     *         certificates and other items as necessary when performing an audit.</p>
     *         <p>
     *         On the first call to <code>UpdateAccountAuditConfiguration</code> this parameter is required.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Information about the targets to which audit notifications are sent for this account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the targets to which audit notifications are sent for this account.
     */
    public Map<AuditNotificationType, AuditNotificationTarget> auditNotificationTargetConfigurations() {
        return TypeConverter.convert(auditNotificationTargetConfigurations, AuditNotificationType::fromValue,
                Function.identity(), (k, v) -> !Objects.equals(k, AuditNotificationType.UNKNOWN_TO_SDK_VERSION));
    }

    /**
     * <p>
     * Information about the targets to which audit notifications are sent for this account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the targets to which audit notifications are sent for this account.
     */
    public Map<String, AuditNotificationTarget> auditNotificationTargetConfigurationsAsStrings() {
        return auditNotificationTargetConfigurations;
    }

    /**
     * <p>
     * Which audit checks are enabled and disabled for this account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Which audit checks are enabled and disabled for this account.
     */
    public Map<String, AuditCheckConfiguration> auditCheckConfigurations() {
        return auditCheckConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(auditNotificationTargetConfigurationsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(auditCheckConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAuditConfigurationResponse)) {
            return false;
        }
        DescribeAccountAuditConfigurationResponse other = (DescribeAccountAuditConfigurationResponse) obj;
        return Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(auditNotificationTargetConfigurationsAsStrings(),
                        other.auditNotificationTargetConfigurationsAsStrings())
                && Objects.equals(auditCheckConfigurations(), other.auditCheckConfigurations());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAccountAuditConfigurationResponse").add("RoleArn", roleArn())
                .add("AuditNotificationTargetConfigurations", auditNotificationTargetConfigurationsAsStrings())
                .add("AuditCheckConfigurations", auditCheckConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "auditNotificationTargetConfigurations":
            return Optional.ofNullable(clazz.cast(auditNotificationTargetConfigurationsAsStrings()));
        case "auditCheckConfigurations":
            return Optional.ofNullable(clazz.cast(auditCheckConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAuditConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeAccountAuditConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountAuditConfigurationResponse> {
        /**
         * <p>
         * The ARN of the role that grants permission to AWS IoT to access information about your devices, policies,
         * certificates and other items as necessary when performing an audit.
         * </p>
         * <p>
         * On the first call to <code>UpdateAccountAuditConfiguration</code> this parameter is required.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants permission to AWS IoT to access information about your devices,
         *        policies, certificates and other items as necessary when performing an audit.</p>
         *        <p>
         *        On the first call to <code>UpdateAccountAuditConfiguration</code> this parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Information about the targets to which audit notifications are sent for this account.
         * </p>
         * 
         * @param auditNotificationTargetConfigurations
         *        Information about the targets to which audit notifications are sent for this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditNotificationTargetConfigurationsWithStrings(
                Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations);

        /**
         * <p>
         * Information about the targets to which audit notifications are sent for this account.
         * </p>
         * 
         * @param auditNotificationTargetConfigurations
         *        Information about the targets to which audit notifications are sent for this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditNotificationTargetConfigurations(
                Map<AuditNotificationType, AuditNotificationTarget> auditNotificationTargetConfigurations);

        /**
         * <p>
         * Which audit checks are enabled and disabled for this account.
         * </p>
         * 
         * @param auditCheckConfigurations
         *        Which audit checks are enabled and disabled for this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditCheckConfigurations(Map<String, AuditCheckConfiguration> auditCheckConfigurations);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String roleArn;

        private Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations = DefaultSdkAutoConstructMap
                .getInstance();

        private Map<String, AuditCheckConfiguration> auditCheckConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAuditConfigurationResponse model) {
            super(model);
            roleArn(model.roleArn);
            auditNotificationTargetConfigurationsWithStrings(model.auditNotificationTargetConfigurations);
            auditCheckConfigurations(model.auditCheckConfigurations);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, AuditNotificationTarget.Builder> getAuditNotificationTargetConfigurations() {
            return auditNotificationTargetConfigurations != null ? CollectionUtils.mapValues(
                    auditNotificationTargetConfigurations, AuditNotificationTarget::toBuilder) : null;
        }

        @Override
        public final Builder auditNotificationTargetConfigurationsWithStrings(
                Map<String, AuditNotificationTarget> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier
                    .copy(auditNotificationTargetConfigurations);
            return this;
        }

        @Override
        public final Builder auditNotificationTargetConfigurations(
                Map<AuditNotificationType, AuditNotificationTarget> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier
                    .copyEnumToString(auditNotificationTargetConfigurations);
            return this;
        }

        public final void setAuditNotificationTargetConfigurations(
                Map<String, AuditNotificationTarget.BuilderImpl> auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = AuditNotificationTargetConfigurationsCopier
                    .copyFromBuilder(auditNotificationTargetConfigurations);
        }

        public final Map<String, AuditCheckConfiguration.Builder> getAuditCheckConfigurations() {
            return auditCheckConfigurations != null ? CollectionUtils.mapValues(auditCheckConfigurations,
                    AuditCheckConfiguration::toBuilder) : null;
        }

        @Override
        public final Builder auditCheckConfigurations(Map<String, AuditCheckConfiguration> auditCheckConfigurations) {
            this.auditCheckConfigurations = AuditCheckConfigurationsCopier.copy(auditCheckConfigurations);
            return this;
        }

        public final void setAuditCheckConfigurations(Map<String, AuditCheckConfiguration.BuilderImpl> auditCheckConfigurations) {
            this.auditCheckConfigurations = AuditCheckConfigurationsCopier.copyFromBuilder(auditCheckConfigurations);
        }

        @Override
        public DescribeAccountAuditConfigurationResponse build() {
            return new DescribeAccountAuditConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
