/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteJobExecutionRequest extends IotRequest implements
        ToCopyableBuilder<DeleteJobExecutionRequest.Builder, DeleteJobExecutionRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteJobExecutionRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteJobExecutionRequest::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()).build();

    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DeleteJobExecutionRequest::executionNumber)).setter(setter(Builder::executionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("executionNumber").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteJobExecutionRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            THING_NAME_FIELD, EXECUTION_NUMBER_FIELD, FORCE_FIELD));

    private final String jobId;

    private final String thingName;

    private final Long executionNumber;

    private final Boolean force;

    private DeleteJobExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.thingName = builder.thingName;
        this.executionNumber = builder.executionNumber;
        this.force = builder.force;
    }

    /**
     * <p>
     * The ID of the job whose execution on a particular device will be deleted.
     * </p>
     * 
     * @return The ID of the job whose execution on a particular device will be deleted.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of the thing whose job execution will be deleted.
     * </p>
     * 
     * @return The name of the thing whose job execution will be deleted.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a
     * particular job on a particular device.
     * </p>
     * <p>
     * Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be sure you
     * get and use the correct value here.
     * </p>
     * 
     * @return The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a
     *         particular job on a particular device.</p>
     *         <p>
     *         Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be
     *         sure you get and use the correct value here.
     */
    public Long executionNumber() {
        return executionNumber;
    }

    /**
     * <p>
     * (Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job
     * execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an
     * exception will occur. The default is false.
     * </p>
     * <note>
     * <p>
     * Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or
     * update the job execution status. Use caution and ensure that the device is able to recover to a valid state.
     * </p>
     * </note>
     * 
     * @return (Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only
     *         delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or
     *         "CANCELED") or an exception will occur. The default is false.</p> <note>
     *         <p>
     *         Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job
     *         information or update the job execution status. Use caution and ensure that the device is able to recover
     *         to a valid state.
     *         </p>
     */
    public Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(executionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteJobExecutionRequest)) {
            return false;
        }
        DeleteJobExecutionRequest other = (DeleteJobExecutionRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(executionNumber(), other.executionNumber()) && Objects.equals(force(), other.force());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteJobExecutionRequest").add("JobId", jobId()).add("ThingName", thingName())
                .add("ExecutionNumber", executionNumber()).add("Force", force()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "executionNumber":
            return Optional.ofNullable(clazz.cast(executionNumber()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteJobExecutionRequest, T> g) {
        return obj -> g.apply((DeleteJobExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteJobExecutionRequest> {
        /**
         * <p>
         * The ID of the job whose execution on a particular device will be deleted.
         * </p>
         * 
         * @param jobId
         *        The ID of the job whose execution on a particular device will be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of the thing whose job execution will be deleted.
         * </p>
         * 
         * @param thingName
         *        The name of the thing whose job execution will be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a
         * particular job on a particular device.
         * </p>
         * <p>
         * Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be sure
         * you get and use the correct value here.
         * </p>
         * 
         * @param executionNumber
         *        The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of
         *        a particular job on a particular device.</p>
         *        <p>
         *        Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so
         *        be sure you get and use the correct value here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionNumber(Long executionNumber);

        /**
         * <p>
         * (Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a
         * job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an
         * exception will occur. The default is false.
         * </p>
         * <note>
         * <p>
         * Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information
         * or update the job execution status. Use caution and ensure that the device is able to recover to a valid
         * state.
         * </p>
         * </note>
         * 
         * @param force
         *        (Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only
         *        delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or
         *        "CANCELED") or an exception will occur. The default is false.</p> <note>
         *        <p>
         *        Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job
         *        information or update the job execution status. Use caution and ensure that the device is able to
         *        recover to a valid state.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String jobId;

        private String thingName;

        private Long executionNumber;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteJobExecutionRequest model) {
            super(model);
            jobId(model.jobId);
            thingName(model.thingName);
            executionNumber(model.executionNumber);
            force(model.force);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Long getExecutionNumber() {
            return executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteJobExecutionRequest build() {
            return new DeleteJobExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
