/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.internetmonitor.model.LocalHealthEventsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HealthEventsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HealthEventsConfig> {
    private static final SdkField<Double> AVAILABILITY_SCORE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AvailabilityScoreThreshold").getter(HealthEventsConfig.getter(HealthEventsConfig::availabilityScoreThreshold)).setter(HealthEventsConfig.setter(Builder::availabilityScoreThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityScoreThreshold").build()}).build();
    private static final SdkField<Double> PERFORMANCE_SCORE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PerformanceScoreThreshold").getter(HealthEventsConfig.getter(HealthEventsConfig::performanceScoreThreshold)).setter(HealthEventsConfig.setter(Builder::performanceScoreThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceScoreThreshold").build()}).build();
    private static final SdkField<LocalHealthEventsConfig> AVAILABILITY_LOCAL_HEALTH_EVENTS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvailabilityLocalHealthEventsConfig").getter(HealthEventsConfig.getter(HealthEventsConfig::availabilityLocalHealthEventsConfig)).setter(HealthEventsConfig.setter(Builder::availabilityLocalHealthEventsConfig)).constructor(LocalHealthEventsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityLocalHealthEventsConfig").build()}).build();
    private static final SdkField<LocalHealthEventsConfig> PERFORMANCE_LOCAL_HEALTH_EVENTS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PerformanceLocalHealthEventsConfig").getter(HealthEventsConfig.getter(HealthEventsConfig::performanceLocalHealthEventsConfig)).setter(HealthEventsConfig.setter(Builder::performanceLocalHealthEventsConfig)).constructor(LocalHealthEventsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceLocalHealthEventsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_SCORE_THRESHOLD_FIELD, PERFORMANCE_SCORE_THRESHOLD_FIELD, AVAILABILITY_LOCAL_HEALTH_EVENTS_CONFIG_FIELD, PERFORMANCE_LOCAL_HEALTH_EVENTS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HealthEventsConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double availabilityScoreThreshold;
    private final Double performanceScoreThreshold;
    private final LocalHealthEventsConfig availabilityLocalHealthEventsConfig;
    private final LocalHealthEventsConfig performanceLocalHealthEventsConfig;

    private HealthEventsConfig(BuilderImpl builder) {
        this.availabilityScoreThreshold = builder.availabilityScoreThreshold;
        this.performanceScoreThreshold = builder.performanceScoreThreshold;
        this.availabilityLocalHealthEventsConfig = builder.availabilityLocalHealthEventsConfig;
        this.performanceLocalHealthEventsConfig = builder.performanceLocalHealthEventsConfig;
    }

    public final Double availabilityScoreThreshold() {
        return this.availabilityScoreThreshold;
    }

    public final Double performanceScoreThreshold() {
        return this.performanceScoreThreshold;
    }

    public final LocalHealthEventsConfig availabilityLocalHealthEventsConfig() {
        return this.availabilityLocalHealthEventsConfig;
    }

    public final LocalHealthEventsConfig performanceLocalHealthEventsConfig() {
        return this.performanceLocalHealthEventsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityScoreThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceScoreThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityLocalHealthEventsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceLocalHealthEventsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthEventsConfig)) {
            return false;
        }
        HealthEventsConfig other = (HealthEventsConfig)obj;
        return Objects.equals(this.availabilityScoreThreshold(), other.availabilityScoreThreshold()) && Objects.equals(this.performanceScoreThreshold(), other.performanceScoreThreshold()) && Objects.equals(this.availabilityLocalHealthEventsConfig(), other.availabilityLocalHealthEventsConfig()) && Objects.equals(this.performanceLocalHealthEventsConfig(), other.performanceLocalHealthEventsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"HealthEventsConfig").add("AvailabilityScoreThreshold", (Object)this.availabilityScoreThreshold()).add("PerformanceScoreThreshold", (Object)this.performanceScoreThreshold()).add("AvailabilityLocalHealthEventsConfig", (Object)this.availabilityLocalHealthEventsConfig()).add("PerformanceLocalHealthEventsConfig", (Object)this.performanceLocalHealthEventsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityScoreThreshold": {
                return Optional.ofNullable(clazz.cast(this.availabilityScoreThreshold()));
            }
            case "PerformanceScoreThreshold": {
                return Optional.ofNullable(clazz.cast(this.performanceScoreThreshold()));
            }
            case "AvailabilityLocalHealthEventsConfig": {
                return Optional.ofNullable(clazz.cast(this.availabilityLocalHealthEventsConfig()));
            }
            case "PerformanceLocalHealthEventsConfig": {
                return Optional.ofNullable(clazz.cast(this.performanceLocalHealthEventsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityScoreThreshold", AVAILABILITY_SCORE_THRESHOLD_FIELD);
        map.put("PerformanceScoreThreshold", PERFORMANCE_SCORE_THRESHOLD_FIELD);
        map.put("AvailabilityLocalHealthEventsConfig", AVAILABILITY_LOCAL_HEALTH_EVENTS_CONFIG_FIELD);
        map.put("PerformanceLocalHealthEventsConfig", PERFORMANCE_LOCAL_HEALTH_EVENTS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HealthEventsConfig, T> g) {
        return obj -> g.apply((HealthEventsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double availabilityScoreThreshold;
        private Double performanceScoreThreshold;
        private LocalHealthEventsConfig availabilityLocalHealthEventsConfig;
        private LocalHealthEventsConfig performanceLocalHealthEventsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthEventsConfig model) {
            this.availabilityScoreThreshold(model.availabilityScoreThreshold);
            this.performanceScoreThreshold(model.performanceScoreThreshold);
            this.availabilityLocalHealthEventsConfig(model.availabilityLocalHealthEventsConfig);
            this.performanceLocalHealthEventsConfig(model.performanceLocalHealthEventsConfig);
        }

        public final Double getAvailabilityScoreThreshold() {
            return this.availabilityScoreThreshold;
        }

        public final void setAvailabilityScoreThreshold(Double availabilityScoreThreshold) {
            this.availabilityScoreThreshold = availabilityScoreThreshold;
        }

        @Override
        public final Builder availabilityScoreThreshold(Double availabilityScoreThreshold) {
            this.availabilityScoreThreshold = availabilityScoreThreshold;
            return this;
        }

        public final Double getPerformanceScoreThreshold() {
            return this.performanceScoreThreshold;
        }

        public final void setPerformanceScoreThreshold(Double performanceScoreThreshold) {
            this.performanceScoreThreshold = performanceScoreThreshold;
        }

        @Override
        public final Builder performanceScoreThreshold(Double performanceScoreThreshold) {
            this.performanceScoreThreshold = performanceScoreThreshold;
            return this;
        }

        public final LocalHealthEventsConfig.Builder getAvailabilityLocalHealthEventsConfig() {
            return this.availabilityLocalHealthEventsConfig != null ? this.availabilityLocalHealthEventsConfig.toBuilder() : null;
        }

        public final void setAvailabilityLocalHealthEventsConfig(LocalHealthEventsConfig.BuilderImpl availabilityLocalHealthEventsConfig) {
            this.availabilityLocalHealthEventsConfig = availabilityLocalHealthEventsConfig != null ? availabilityLocalHealthEventsConfig.build() : null;
        }

        @Override
        public final Builder availabilityLocalHealthEventsConfig(LocalHealthEventsConfig availabilityLocalHealthEventsConfig) {
            this.availabilityLocalHealthEventsConfig = availabilityLocalHealthEventsConfig;
            return this;
        }

        public final LocalHealthEventsConfig.Builder getPerformanceLocalHealthEventsConfig() {
            return this.performanceLocalHealthEventsConfig != null ? this.performanceLocalHealthEventsConfig.toBuilder() : null;
        }

        public final void setPerformanceLocalHealthEventsConfig(LocalHealthEventsConfig.BuilderImpl performanceLocalHealthEventsConfig) {
            this.performanceLocalHealthEventsConfig = performanceLocalHealthEventsConfig != null ? performanceLocalHealthEventsConfig.build() : null;
        }

        @Override
        public final Builder performanceLocalHealthEventsConfig(LocalHealthEventsConfig performanceLocalHealthEventsConfig) {
            this.performanceLocalHealthEventsConfig = performanceLocalHealthEventsConfig;
            return this;
        }

        public HealthEventsConfig build() {
            return new HealthEventsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HealthEventsConfig> {
        public Builder availabilityScoreThreshold(Double var1);

        public Builder performanceScoreThreshold(Double var1);

        public Builder availabilityLocalHealthEventsConfig(LocalHealthEventsConfig var1);

        default public Builder availabilityLocalHealthEventsConfig(Consumer<LocalHealthEventsConfig.Builder> availabilityLocalHealthEventsConfig) {
            return this.availabilityLocalHealthEventsConfig((LocalHealthEventsConfig)((LocalHealthEventsConfig.Builder)LocalHealthEventsConfig.builder().applyMutation(availabilityLocalHealthEventsConfig)).build());
        }

        public Builder performanceLocalHealthEventsConfig(LocalHealthEventsConfig var1);

        default public Builder performanceLocalHealthEventsConfig(Consumer<LocalHealthEventsConfig.Builder> performanceLocalHealthEventsConfig) {
            return this.performanceLocalHealthEventsConfig((LocalHealthEventsConfig)((LocalHealthEventsConfig.Builder)LocalHealthEventsConfig.builder().applyMutation(performanceLocalHealthEventsConfig)).build());
        }
    }
}

