/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the network impairment for a specific network measured by Amazon CloudWatch Internet Monitor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkImpairment implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkImpairment.Builder, NetworkImpairment> {
    private static final SdkField<List<Network>> NETWORKS_FIELD = SdkField
            .<List<Network>> builder(MarshallingType.LIST)
            .memberName("Networks")
            .getter(getter(NetworkImpairment::networks))
            .setter(setter(Builder::networks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Networks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Network> builder(MarshallingType.SDK_POJO)
                                            .constructor(Network::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Network>> AS_PATH_FIELD = SdkField
            .<List<Network>> builder(MarshallingType.LIST)
            .memberName("AsPath")
            .getter(getter(NetworkImpairment::asPath))
            .setter(setter(Builder::asPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsPath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Network> builder(MarshallingType.SDK_POJO)
                                            .constructor(Network::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NETWORK_EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkEventType").getter(getter(NetworkImpairment::networkEventTypeAsString))
            .setter(setter(Builder::networkEventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkEventType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORKS_FIELD, AS_PATH_FIELD,
            NETWORK_EVENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Network> networks;

    private final List<Network> asPath;

    private final String networkEventType;

    private NetworkImpairment(BuilderImpl builder) {
        this.networks = builder.networks;
        this.asPath = builder.asPath;
        this.networkEventType = builder.networkEventType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Networks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNetworks() {
        return networks != null && !(networks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The networks that could be impacted by a network impairment event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworks} method.
     * </p>
     * 
     * @return The networks that could be impacted by a network impairment event.
     */
    public final List<Network> networks() {
        return networks;
    }

    /**
     * For responses, this returns true if the service returned a value for the AsPath property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAsPath() {
        return asPath != null && !(asPath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The combination of the Autonomous System Number (ASN) of the network and the name of the network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAsPath} method.
     * </p>
     * 
     * @return The combination of the Autonomous System Number (ASN) of the network and the name of the network.
     */
    public final List<Network> asPath() {
        return asPath;
    }

    /**
     * <p>
     * The type of network impairment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkEventType}
     * will return {@link TriangulationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #networkEventTypeAsString}.
     * </p>
     * 
     * @return The type of network impairment.
     * @see TriangulationEventType
     */
    public final TriangulationEventType networkEventType() {
        return TriangulationEventType.fromValue(networkEventType);
    }

    /**
     * <p>
     * The type of network impairment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkEventType}
     * will return {@link TriangulationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #networkEventTypeAsString}.
     * </p>
     * 
     * @return The type of network impairment.
     * @see TriangulationEventType
     */
    public final String networkEventTypeAsString() {
        return networkEventType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworks() ? networks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAsPath() ? asPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkEventTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkImpairment)) {
            return false;
        }
        NetworkImpairment other = (NetworkImpairment) obj;
        return hasNetworks() == other.hasNetworks() && Objects.equals(networks(), other.networks())
                && hasAsPath() == other.hasAsPath() && Objects.equals(asPath(), other.asPath())
                && Objects.equals(networkEventTypeAsString(), other.networkEventTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkImpairment").add("Networks", hasNetworks() ? networks() : null)
                .add("AsPath", hasAsPath() ? asPath() : null).add("NetworkEventType", networkEventTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Networks":
            return Optional.ofNullable(clazz.cast(networks()));
        case "AsPath":
            return Optional.ofNullable(clazz.cast(asPath()));
        case "NetworkEventType":
            return Optional.ofNullable(clazz.cast(networkEventTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Networks", NETWORKS_FIELD);
        map.put("AsPath", AS_PATH_FIELD);
        map.put("NetworkEventType", NETWORK_EVENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkImpairment, T> g) {
        return obj -> g.apply((NetworkImpairment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkImpairment> {
        /**
         * <p>
         * The networks that could be impacted by a network impairment event.
         * </p>
         * 
         * @param networks
         *        The networks that could be impacted by a network impairment event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networks(Collection<Network> networks);

        /**
         * <p>
         * The networks that could be impacted by a network impairment event.
         * </p>
         * 
         * @param networks
         *        The networks that could be impacted by a network impairment event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networks(Network... networks);

        /**
         * <p>
         * The networks that could be impacted by a network impairment event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.internetmonitor.model.Network.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.internetmonitor.model.Network#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.internetmonitor.model.Network.Builder#build()} is called immediately
         * and its result is passed to {@link #networks(List<Network>)}.
         * 
         * @param networks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.internetmonitor.model.Network.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networks(java.util.Collection<Network>)
         */
        Builder networks(Consumer<Network.Builder>... networks);

        /**
         * <p>
         * The combination of the Autonomous System Number (ASN) of the network and the name of the network.
         * </p>
         * 
         * @param asPath
         *        The combination of the Autonomous System Number (ASN) of the network and the name of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asPath(Collection<Network> asPath);

        /**
         * <p>
         * The combination of the Autonomous System Number (ASN) of the network and the name of the network.
         * </p>
         * 
         * @param asPath
         *        The combination of the Autonomous System Number (ASN) of the network and the name of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asPath(Network... asPath);

        /**
         * <p>
         * The combination of the Autonomous System Number (ASN) of the network and the name of the network.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.internetmonitor.model.Network.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.internetmonitor.model.Network#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.internetmonitor.model.Network.Builder#build()} is called immediately
         * and its result is passed to {@link #asPath(List<Network>)}.
         * 
         * @param asPath
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.internetmonitor.model.Network.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #asPath(java.util.Collection<Network>)
         */
        Builder asPath(Consumer<Network.Builder>... asPath);

        /**
         * <p>
         * The type of network impairment.
         * </p>
         * 
         * @param networkEventType
         *        The type of network impairment.
         * @see TriangulationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriangulationEventType
         */
        Builder networkEventType(String networkEventType);

        /**
         * <p>
         * The type of network impairment.
         * </p>
         * 
         * @param networkEventType
         *        The type of network impairment.
         * @see TriangulationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriangulationEventType
         */
        Builder networkEventType(TriangulationEventType networkEventType);
    }

    static final class BuilderImpl implements Builder {
        private List<Network> networks = DefaultSdkAutoConstructList.getInstance();

        private List<Network> asPath = DefaultSdkAutoConstructList.getInstance();

        private String networkEventType;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkImpairment model) {
            networks(model.networks);
            asPath(model.asPath);
            networkEventType(model.networkEventType);
        }

        public final List<Network.Builder> getNetworks() {
            List<Network.Builder> result = NetworkListCopier.copyToBuilder(this.networks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworks(Collection<Network.BuilderImpl> networks) {
            this.networks = NetworkListCopier.copyFromBuilder(networks);
        }

        @Override
        public final Builder networks(Collection<Network> networks) {
            this.networks = NetworkListCopier.copy(networks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(Network... networks) {
            networks(Arrays.asList(networks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(Consumer<Network.Builder>... networks) {
            networks(Stream.of(networks).map(c -> Network.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Network.Builder> getAsPath() {
            List<Network.Builder> result = NetworkListCopier.copyToBuilder(this.asPath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAsPath(Collection<Network.BuilderImpl> asPath) {
            this.asPath = NetworkListCopier.copyFromBuilder(asPath);
        }

        @Override
        public final Builder asPath(Collection<Network> asPath) {
            this.asPath = NetworkListCopier.copy(asPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asPath(Network... asPath) {
            asPath(Arrays.asList(asPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asPath(Consumer<Network.Builder>... asPath) {
            asPath(Stream.of(asPath).map(c -> Network.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNetworkEventType() {
            return networkEventType;
        }

        public final void setNetworkEventType(String networkEventType) {
            this.networkEventType = networkEventType;
        }

        @Override
        public final Builder networkEventType(String networkEventType) {
            this.networkEventType = networkEventType;
            return this;
        }

        @Override
        public final Builder networkEventType(TriangulationEventType networkEventType) {
            this.networkEventType(networkEventType == null ? null : networkEventType.toString());
            return this;
        }

        @Override
        public NetworkImpairment build() {
            return new NetworkImpairment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
