/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueryResultsResponse extends InternetMonitorResponse implements
        ToCopyableBuilder<GetQueryResultsResponse.Builder, GetQueryResultsResponse> {
    private static final SdkField<List<QueryField>> FIELDS_FIELD = SdkField
            .<List<QueryField>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(GetQueryResultsResponse::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryField> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<List<String>>> DATA_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("Data")
            .getter(getter(GetQueryResultsResponse::data))
            .setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetQueryResultsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD, DATA_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<QueryField> fields;

    private final List<List<String>> data;

    private final String nextToken;

    private GetQueryResultsResponse(BuilderImpl builder) {
        super(builder);
        this.fields = builder.fields;
        this.data = builder.data;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The fields that the query returns data for. Fields are name-data type pairs, such as
     * <code>availability_score</code>-<code>float</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return The fields that the query returns data for. Fields are name-data type pairs, such as
     *         <code>availability_score</code>-<code>float</code>.
     */
    public final List<QueryField> fields() {
        return fields;
    }

    /**
     * For responses, this returns true if the service returned a value for the Data property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasData() {
        return data != null && !(data instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data results that the query returns. Data is returned in arrays, aligned with the <code>Fields</code> for the
     * query, which creates a repository of Amazon CloudWatch Internet Monitor information for your application. Then,
     * you can filter the information in the repository by using <code>FilterParameters</code> that you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasData} method.
     * </p>
     * 
     * @return The data results that the query returns. Data is returned in arrays, aligned with the <code>Fields</code>
     *         for the query, which creates a repository of Amazon CloudWatch Internet Monitor information for your
     *         application. Then, you can filter the information in the repository by using
     *         <code>FilterParameters</code> that you define.
     */
    public final List<List<String>> data() {
        return data;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasData() ? data() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsResponse)) {
            return false;
        }
        GetQueryResultsResponse other = (GetQueryResultsResponse) obj;
        return hasFields() == other.hasFields() && Objects.equals(fields(), other.fields()) && hasData() == other.hasData()
                && Objects.equals(data(), other.data()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQueryResultsResponse").add("Fields", hasFields() ? fields() : null)
                .add("Data", hasData() ? data() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsResponse, T> g) {
        return obj -> g.apply((GetQueryResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InternetMonitorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQueryResultsResponse> {
        /**
         * <p>
         * The fields that the query returns data for. Fields are name-data type pairs, such as
         * <code>availability_score</code>-<code>float</code>.
         * </p>
         * 
         * @param fields
         *        The fields that the query returns data for. Fields are name-data type pairs, such as
         *        <code>availability_score</code>-<code>float</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<QueryField> fields);

        /**
         * <p>
         * The fields that the query returns data for. Fields are name-data type pairs, such as
         * <code>availability_score</code>-<code>float</code>.
         * </p>
         * 
         * @param fields
         *        The fields that the query returns data for. Fields are name-data type pairs, such as
         *        <code>availability_score</code>-<code>float</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(QueryField... fields);

        /**
         * <p>
         * The fields that the query returns data for. Fields are name-data type pairs, such as
         * <code>availability_score</code>-<code>float</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.internetmonitor.model.QueryField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.internetmonitor.model.QueryField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.internetmonitor.model.QueryField.Builder#build()} is called
         * immediately and its result is passed to {@link #fields(List<QueryField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.internetmonitor.model.QueryField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<QueryField>)
         */
        Builder fields(Consumer<QueryField.Builder>... fields);

        /**
         * <p>
         * The data results that the query returns. Data is returned in arrays, aligned with the <code>Fields</code> for
         * the query, which creates a repository of Amazon CloudWatch Internet Monitor information for your application.
         * Then, you can filter the information in the repository by using <code>FilterParameters</code> that you
         * define.
         * </p>
         * 
         * @param data
         *        The data results that the query returns. Data is returned in arrays, aligned with the
         *        <code>Fields</code> for the query, which creates a repository of Amazon CloudWatch Internet Monitor
         *        information for your application. Then, you can filter the information in the repository by using
         *        <code>FilterParameters</code> that you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Collection<? extends Collection<String>> data);

        /**
         * <p>
         * The data results that the query returns. Data is returned in arrays, aligned with the <code>Fields</code> for
         * the query, which creates a repository of Amazon CloudWatch Internet Monitor information for your application.
         * Then, you can filter the information in the repository by using <code>FilterParameters</code> that you
         * define.
         * </p>
         * 
         * @param data
         *        The data results that the query returns. Data is returned in arrays, aligned with the
         *        <code>Fields</code> for the query, which creates a repository of Amazon CloudWatch Internet Monitor
         *        information for your application. Then, you can filter the information in the repository by using
         *        <code>FilterParameters</code> that you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Collection<String>... data);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends InternetMonitorResponse.BuilderImpl implements Builder {
        private List<QueryField> fields = DefaultSdkAutoConstructList.getInstance();

        private List<List<String>> data = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsResponse model) {
            super(model);
            fields(model.fields);
            data(model.data);
            nextToken(model.nextToken);
        }

        public final List<QueryField.Builder> getFields() {
            List<QueryField.Builder> result = QueryFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<QueryField.BuilderImpl> fields) {
            this.fields = QueryFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<QueryField> fields) {
            this.fields = QueryFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(QueryField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<QueryField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> QueryField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Collection<String>> getData() {
            if (data instanceof SdkAutoConstructList) {
                return null;
            }
            return data;
        }

        public final void setData(Collection<? extends Collection<String>> data) {
            this.data = QueryDataCopier.copy(data);
        }

        @Override
        public final Builder data(Collection<? extends Collection<String>> data) {
            this.data = QueryDataCopier.copy(data);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Collection<String>... data) {
            data(Arrays.asList(data));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetQueryResultsResponse build() {
            return new GetQueryResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
