/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHealthEventRequest extends InternetMonitorRequest implements
        ToCopyableBuilder<GetHealthEventRequest.Builder, GetHealthEventRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorName").getter(getter(GetHealthEventRequest::monitorName)).setter(setter(Builder::monitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MonitorName").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventId").getter(getter(GetHealthEventRequest::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EventId").build()).build();

    private static final SdkField<String> LINKED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LinkedAccountId").getter(getter(GetHealthEventRequest::linkedAccountId))
            .setter(setter(Builder::linkedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LinkedAccountId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD,
            EVENT_ID_FIELD, LINKED_ACCOUNT_ID_FIELD));

    private final String monitorName;

    private final String eventId;

    private final String linkedAccountId;

    private GetHealthEventRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.eventId = builder.eventId;
        this.linkedAccountId = builder.linkedAccountId;
    }

    /**
     * <p>
     * The name of the monitor.
     * </p>
     * 
     * @return The name of the monitor.
     */
    public final String monitorName() {
        return monitorName;
    }

    /**
     * <p>
     * The internally-generated identifier of a health event. Because <code>EventID</code> contains the forward slash
     * (“/”) character, you must URL-encode the <code>EventID</code> field in the request URL.
     * </p>
     * 
     * @return The internally-generated identifier of a health event. Because <code>EventID</code> contains the forward
     *         slash (“/”) character, you must URL-encode the <code>EventID</code> field in the request URL.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * TBD
     * </p>
     * 
     * @return TBD
     */
    public final String linkedAccountId() {
        return linkedAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(linkedAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthEventRequest)) {
            return false;
        }
        GetHealthEventRequest other = (GetHealthEventRequest) obj;
        return Objects.equals(monitorName(), other.monitorName()) && Objects.equals(eventId(), other.eventId())
                && Objects.equals(linkedAccountId(), other.linkedAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetHealthEventRequest").add("MonitorName", monitorName()).add("EventId", eventId())
                .add("LinkedAccountId", linkedAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitorName":
            return Optional.ofNullable(clazz.cast(monitorName()));
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "LinkedAccountId":
            return Optional.ofNullable(clazz.cast(linkedAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHealthEventRequest, T> g) {
        return obj -> g.apply((GetHealthEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InternetMonitorRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetHealthEventRequest> {
        /**
         * <p>
         * The name of the monitor.
         * </p>
         * 
         * @param monitorName
         *        The name of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorName(String monitorName);

        /**
         * <p>
         * The internally-generated identifier of a health event. Because <code>EventID</code> contains the forward
         * slash (“/”) character, you must URL-encode the <code>EventID</code> field in the request URL.
         * </p>
         * 
         * @param eventId
         *        The internally-generated identifier of a health event. Because <code>EventID</code> contains the
         *        forward slash (“/”) character, you must URL-encode the <code>EventID</code> field in the request URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * TBD
         * </p>
         * 
         * @param linkedAccountId
         *        TBD
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedAccountId(String linkedAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InternetMonitorRequest.BuilderImpl implements Builder {
        private String monitorName;

        private String eventId;

        private String linkedAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthEventRequest model) {
            super(model);
            monitorName(model.monitorName);
            eventId(model.eventId);
            linkedAccountId(model.linkedAccountId);
        }

        public final String getMonitorName() {
            return monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getLinkedAccountId() {
            return linkedAccountId;
        }

        public final void setLinkedAccountId(String linkedAccountId) {
            this.linkedAccountId = linkedAccountId;
        }

        @Override
        public final Builder linkedAccountId(String linkedAccountId) {
            this.linkedAccountId = linkedAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetHealthEventRequest build() {
            return new GetHealthEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
