/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MonitorProcessingStatusCode {
    OK("OK"),
    INACTIVE("INACTIVE"),
    COLLECTING_DATA("COLLECTING_DATA"),
    INSUFFICIENT_DATA("INSUFFICIENT_DATA"),
    FAULT_SERVICE("FAULT_SERVICE"),
    FAULT_ACCESS_CLOUDWATCH("FAULT_ACCESS_CLOUDWATCH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MonitorProcessingStatusCode> VALUE_MAP;
    private final String value;

    private MonitorProcessingStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MonitorProcessingStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MonitorProcessingStatusCode> knownValues() {
        EnumSet<MonitorProcessingStatusCode> knownValues = EnumSet.allOf(MonitorProcessingStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MonitorProcessingStatusCode.class, MonitorProcessingStatusCode::toString);
    }
}

