/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Measurements about the availability for your application on the internet, calculated by Amazon CloudWatch Internet
 * Monitor. Amazon Web Services has substantial historical data about internet performance and availability between
 * Amazon Web Services services and different network providers and geographies. By applying statistical analysis to the
 * data, Internet Monitor can detect when the performance and availability for your application has dropped, compared to
 * an estimated baseline that's already calculated. To make it easier to see those drops, we report that information to
 * you in the form of health scores: a performance score and an availability score.
 * </p>
 * <p>
 * Availability in Internet Monitor represents the estimated percentage of traffic that is not seeing an availability
 * drop. For example, an availability score of 99% for an end user and service location pair is equivalent to 1% of the
 * traffic experiencing an availability drop for that pair.
 * </p>
 * <p>
 * For more information, see <a href=
 * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
 * >How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch Internet Monitor
 * section of the <i>Amazon CloudWatch User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityMeasurement implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailabilityMeasurement.Builder, AvailabilityMeasurement> {
    private static final SdkField<Double> EXPERIENCE_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ExperienceScore").getter(getter(AvailabilityMeasurement::experienceScore))
            .setter(setter(Builder::experienceScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperienceScore").build()).build();

    private static final SdkField<Double> PERCENT_OF_TOTAL_TRAFFIC_IMPACTED_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("PercentOfTotalTrafficImpacted")
            .getter(getter(AvailabilityMeasurement::percentOfTotalTrafficImpacted))
            .setter(setter(Builder::percentOfTotalTrafficImpacted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentOfTotalTrafficImpacted")
                    .build()).build();

    private static final SdkField<Double> PERCENT_OF_CLIENT_LOCATION_IMPACTED_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("PercentOfClientLocationImpacted")
            .getter(getter(AvailabilityMeasurement::percentOfClientLocationImpacted))
            .setter(setter(Builder::percentOfClientLocationImpacted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentOfClientLocationImpacted")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIENCE_SCORE_FIELD,
            PERCENT_OF_TOTAL_TRAFFIC_IMPACTED_FIELD, PERCENT_OF_CLIENT_LOCATION_IMPACTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double experienceScore;

    private final Double percentOfTotalTrafficImpacted;

    private final Double percentOfClientLocationImpacted;

    private AvailabilityMeasurement(BuilderImpl builder) {
        this.experienceScore = builder.experienceScore;
        this.percentOfTotalTrafficImpacted = builder.percentOfTotalTrafficImpacted;
        this.percentOfClientLocationImpacted = builder.percentOfClientLocationImpacted;
    }

    /**
     * <p>
     * Experience scores, or health scores are calculated for different geographic and network provider combinations
     * (that is, different granularities) and also summed into global scores. If you view performance or availability
     * scores without filtering for any specific geography or service provider, Amazon CloudWatch Internet Monitor
     * provides global health scores.
     * </p>
     * <p>
     * The Amazon CloudWatch Internet Monitor chapter in the <i>CloudWatch User Guide</i> includes detailed information
     * about how Internet Monitor calculates health scores, including performance and availability scores, and when it
     * creates and resolves health events. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
     * >How Amazon Web Services calculates performance and availability scores</a> in the Amazon CloudWatch Internet
     * Monitor section of the <i>CloudWatch User Guide</i>.
     * </p>
     * 
     * @return Experience scores, or health scores are calculated for different geographic and network provider
     *         combinations (that is, different granularities) and also summed into global scores. If you view
     *         performance or availability scores without filtering for any specific geography or service provider,
     *         Amazon CloudWatch Internet Monitor provides global health scores.</p>
     *         <p>
     *         The Amazon CloudWatch Internet Monitor chapter in the <i>CloudWatch User Guide</i> includes detailed
     *         information about how Internet Monitor calculates health scores, including performance and availability
     *         scores, and when it creates and resolves health events. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
     *         >How Amazon Web Services calculates performance and availability scores</a> in the Amazon CloudWatch
     *         Internet Monitor section of the <i>CloudWatch User Guide</i>.
     */
    public final Double experienceScore() {
        return experienceScore;
    }

    /**
     * <p>
     * The percentage of impact caused by a health event for total traffic globally.
     * </p>
     * <p>
     * For information about how Internet Monitor calculates impact, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html"
     * >Inside Internet Monitor</a> in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch User
     * Guide.
     * </p>
     * 
     * @return The percentage of impact caused by a health event for total traffic globally.</p>
     *         <p>
     *         For information about how Internet Monitor calculates impact, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html"
     *         >Inside Internet Monitor</a> in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch
     *         User Guide.
     */
    public final Double percentOfTotalTrafficImpacted() {
        return percentOfTotalTrafficImpacted;
    }

    /**
     * <p>
     * The percentage of impact caused by a health event for client location traffic globally.
     * </p>
     * <p>
     * For information about how Internet Monitor calculates impact, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html"
     * >Inside Internet Monitor</a> in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch User
     * Guide.
     * </p>
     * 
     * @return The percentage of impact caused by a health event for client location traffic globally.</p>
     *         <p>
     *         For information about how Internet Monitor calculates impact, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html"
     *         >Inside Internet Monitor</a> in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch
     *         User Guide.
     */
    public final Double percentOfClientLocationImpacted() {
        return percentOfClientLocationImpacted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(experienceScore());
        hashCode = 31 * hashCode + Objects.hashCode(percentOfTotalTrafficImpacted());
        hashCode = 31 * hashCode + Objects.hashCode(percentOfClientLocationImpacted());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityMeasurement)) {
            return false;
        }
        AvailabilityMeasurement other = (AvailabilityMeasurement) obj;
        return Objects.equals(experienceScore(), other.experienceScore())
                && Objects.equals(percentOfTotalTrafficImpacted(), other.percentOfTotalTrafficImpacted())
                && Objects.equals(percentOfClientLocationImpacted(), other.percentOfClientLocationImpacted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailabilityMeasurement").add("ExperienceScore", experienceScore())
                .add("PercentOfTotalTrafficImpacted", percentOfTotalTrafficImpacted())
                .add("PercentOfClientLocationImpacted", percentOfClientLocationImpacted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExperienceScore":
            return Optional.ofNullable(clazz.cast(experienceScore()));
        case "PercentOfTotalTrafficImpacted":
            return Optional.ofNullable(clazz.cast(percentOfTotalTrafficImpacted()));
        case "PercentOfClientLocationImpacted":
            return Optional.ofNullable(clazz.cast(percentOfClientLocationImpacted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityMeasurement, T> g) {
        return obj -> g.apply((AvailabilityMeasurement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailabilityMeasurement> {
        /**
         * <p>
         * Experience scores, or health scores are calculated for different geographic and network provider combinations
         * (that is, different granularities) and also summed into global scores. If you view performance or
         * availability scores without filtering for any specific geography or service provider, Amazon CloudWatch
         * Internet Monitor provides global health scores.
         * </p>
         * <p>
         * The Amazon CloudWatch Internet Monitor chapter in the <i>CloudWatch User Guide</i> includes detailed
         * information about how Internet Monitor calculates health scores, including performance and availability
         * scores, and when it creates and resolves health events. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
         * >How Amazon Web Services calculates performance and availability scores</a> in the Amazon CloudWatch Internet
         * Monitor section of the <i>CloudWatch User Guide</i>.
         * </p>
         * 
         * @param experienceScore
         *        Experience scores, or health scores are calculated for different geographic and network provider
         *        combinations (that is, different granularities) and also summed into global scores. If you view
         *        performance or availability scores without filtering for any specific geography or service provider,
         *        Amazon CloudWatch Internet Monitor provides global health scores.</p>
         *        <p>
         *        The Amazon CloudWatch Internet Monitor chapter in the <i>CloudWatch User Guide</i> includes detailed
         *        information about how Internet Monitor calculates health scores, including performance and
         *        availability scores, and when it creates and resolves health events. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
         *        >How Amazon Web Services calculates performance and availability scores</a> in the Amazon CloudWatch
         *        Internet Monitor section of the <i>CloudWatch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experienceScore(Double experienceScore);

        /**
         * <p>
         * The percentage of impact caused by a health event for total traffic globally.
         * </p>
         * <p>
         * For information about how Internet Monitor calculates impact, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html"
         * >Inside Internet Monitor</a> in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch User
         * Guide.
         * </p>
         * 
         * @param percentOfTotalTrafficImpacted
         *        The percentage of impact caused by a health event for total traffic globally.</p>
         *        <p>
         *        For information about how Internet Monitor calculates impact, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html"
         *        >Inside Internet Monitor</a> in the Amazon CloudWatch Internet Monitor section of the Amazon
         *        CloudWatch User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentOfTotalTrafficImpacted(Double percentOfTotalTrafficImpacted);

        /**
         * <p>
         * The percentage of impact caused by a health event for client location traffic globally.
         * </p>
         * <p>
         * For information about how Internet Monitor calculates impact, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html"
         * >Inside Internet Monitor</a> in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch User
         * Guide.
         * </p>
         * 
         * @param percentOfClientLocationImpacted
         *        The percentage of impact caused by a health event for client location traffic globally.</p>
         *        <p>
         *        For information about how Internet Monitor calculates impact, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html"
         *        >Inside Internet Monitor</a> in the Amazon CloudWatch Internet Monitor section of the Amazon
         *        CloudWatch User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentOfClientLocationImpacted(Double percentOfClientLocationImpacted);
    }

    static final class BuilderImpl implements Builder {
        private Double experienceScore;

        private Double percentOfTotalTrafficImpacted;

        private Double percentOfClientLocationImpacted;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityMeasurement model) {
            experienceScore(model.experienceScore);
            percentOfTotalTrafficImpacted(model.percentOfTotalTrafficImpacted);
            percentOfClientLocationImpacted(model.percentOfClientLocationImpacted);
        }

        public final Double getExperienceScore() {
            return experienceScore;
        }

        public final void setExperienceScore(Double experienceScore) {
            this.experienceScore = experienceScore;
        }

        @Override
        public final Builder experienceScore(Double experienceScore) {
            this.experienceScore = experienceScore;
            return this;
        }

        public final Double getPercentOfTotalTrafficImpacted() {
            return percentOfTotalTrafficImpacted;
        }

        public final void setPercentOfTotalTrafficImpacted(Double percentOfTotalTrafficImpacted) {
            this.percentOfTotalTrafficImpacted = percentOfTotalTrafficImpacted;
        }

        @Override
        public final Builder percentOfTotalTrafficImpacted(Double percentOfTotalTrafficImpacted) {
            this.percentOfTotalTrafficImpacted = percentOfTotalTrafficImpacted;
            return this;
        }

        public final Double getPercentOfClientLocationImpacted() {
            return percentOfClientLocationImpacted;
        }

        public final void setPercentOfClientLocationImpacted(Double percentOfClientLocationImpacted) {
            this.percentOfClientLocationImpacted = percentOfClientLocationImpacted;
        }

        @Override
        public final Builder percentOfClientLocationImpacted(Double percentOfClientLocationImpacted) {
            this.percentOfClientLocationImpacted = percentOfClientLocationImpacted;
            return this;
        }

        @Override
        public AvailabilityMeasurement build() {
            return new AvailabilityMeasurement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
