/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Runtime {
    NODEJS("NODEJS"),
    NODEJS_12_X("NODEJS_12_X"),
    NODEJS_14_X("NODEJS_14_X"),
    NODEJS_16_X("NODEJS_16_X"),
    JAVA_8("JAVA_8"),
    JAVA_8_AL2("JAVA_8_AL2"),
    JAVA_11("JAVA_11"),
    PYTHON_3_7("PYTHON_3_7"),
    PYTHON_3_8("PYTHON_3_8"),
    PYTHON_3_9("PYTHON_3_9"),
    UNSUPPORTED("UNSUPPORTED"),
    NODEJS_18_X("NODEJS_18_X"),
    GO_1_X("GO_1_X"),
    JAVA_17("JAVA_17"),
    PYTHON_3_10("PYTHON_3_10"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Runtime> VALUE_MAP;
    private final String value;

    private Runtime(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Runtime fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Runtime> knownValues() {
        EnumSet<Runtime> knownValues = EnumSet.allOf(Runtime.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Runtime.class, Runtime::toString);
    }
}

