/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.identitystore.model.GroupMembership;
import software.amazon.awssdk.services.identitystore.model.GroupMembershipsCopier;
import software.amazon.awssdk.services.identitystore.model.IdentitystoreResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupMembershipsResponse
extends IdentitystoreResponse
implements ToCopyableBuilder<Builder, ListGroupMembershipsResponse> {
    private static final SdkField<List<GroupMembership>> GROUP_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupMemberships").getter(ListGroupMembershipsResponse.getter(ListGroupMembershipsResponse::groupMemberships)).setter(ListGroupMembershipsResponse.setter(Builder::groupMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupMemberships").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGroupMembershipsResponse.getter(ListGroupMembershipsResponse::nextToken)).setter(ListGroupMembershipsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_MEMBERSHIPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GroupMemberships", GROUP_MEMBERSHIPS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<GroupMembership> groupMemberships;
    private final String nextToken;

    private ListGroupMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.groupMemberships = builder.groupMemberships;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGroupMemberships() {
        return this.groupMemberships != null && !(this.groupMemberships instanceof SdkAutoConstructList);
    }

    public final List<GroupMembership> groupMemberships() {
        return this.groupMemberships;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupMemberships() ? this.groupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupMembershipsResponse)) {
            return false;
        }
        ListGroupMembershipsResponse other = (ListGroupMembershipsResponse)((Object)obj);
        return this.hasGroupMemberships() == other.hasGroupMemberships() && Objects.equals(this.groupMemberships(), other.groupMemberships()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupMembershipsResponse").add("GroupMemberships", this.hasGroupMemberships() ? this.groupMemberships() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupMemberships": {
                return Optional.ofNullable(clazz.cast(this.groupMemberships()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupMembershipsResponse, T> g) {
        return obj -> g.apply((ListGroupMembershipsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IdentitystoreResponse.BuilderImpl
    implements Builder {
        private List<GroupMembership> groupMemberships = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupMembershipsResponse model) {
            super(model);
            this.groupMemberships(model.groupMemberships);
            this.nextToken(model.nextToken);
        }

        public final List<GroupMembership.Builder> getGroupMemberships() {
            List<GroupMembership.Builder> result = GroupMembershipsCopier.copyToBuilder(this.groupMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupMemberships(Collection<GroupMembership.BuilderImpl> groupMemberships) {
            this.groupMemberships = GroupMembershipsCopier.copyFromBuilder(groupMemberships);
        }

        @Override
        public final Builder groupMemberships(Collection<GroupMembership> groupMemberships) {
            this.groupMemberships = GroupMembershipsCopier.copy(groupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupMemberships(GroupMembership ... groupMemberships) {
            this.groupMemberships(Arrays.asList(groupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupMemberships(Consumer<GroupMembership.Builder> ... groupMemberships) {
            this.groupMemberships(Stream.of(groupMemberships).map(c -> (GroupMembership)((GroupMembership.Builder)GroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGroupMembershipsResponse build() {
            return new ListGroupMembershipsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IdentitystoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupMembershipsResponse> {
        public Builder groupMemberships(Collection<GroupMembership> var1);

        public Builder groupMemberships(GroupMembership ... var1);

        public Builder groupMemberships(Consumer<GroupMembership.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

