/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.identitystore.model.GroupIdsCopier;
import software.amazon.awssdk.services.identitystore.model.IdentitystoreRequest;
import software.amazon.awssdk.services.identitystore.model.MemberId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IsMemberInGroupsRequest
extends IdentitystoreRequest
implements ToCopyableBuilder<Builder, IsMemberInGroupsRequest> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityStoreId").getter(IsMemberInGroupsRequest.getter(IsMemberInGroupsRequest::identityStoreId)).setter(IsMemberInGroupsRequest.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()}).build();
    private static final SdkField<MemberId> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemberId").getter(IsMemberInGroupsRequest.getter(IsMemberInGroupsRequest::memberId)).setter(IsMemberInGroupsRequest.setter(Builder::memberId)).constructor(MemberId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()}).build();
    private static final SdkField<List<String>> GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupIds").getter(IsMemberInGroupsRequest.getter(IsMemberInGroupsRequest::groupIds)).setter(IsMemberInGroupsRequest.setter(Builder::groupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD, MEMBER_ID_FIELD, GROUP_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IdentityStoreId", IDENTITY_STORE_ID_FIELD);
            this.put("MemberId", MEMBER_ID_FIELD);
            this.put("GroupIds", GROUP_IDS_FIELD);
        }
    });
    private final String identityStoreId;
    private final MemberId memberId;
    private final List<String> groupIds;

    private IsMemberInGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.memberId = builder.memberId;
        this.groupIds = builder.groupIds;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public final MemberId memberId() {
        return this.memberId;
    }

    public final boolean hasGroupIds() {
        return this.groupIds != null && !(this.groupIds instanceof SdkAutoConstructList);
    }

    public final List<String> groupIds() {
        return this.groupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupIds() ? this.groupIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsMemberInGroupsRequest)) {
            return false;
        }
        IsMemberInGroupsRequest other = (IsMemberInGroupsRequest)((Object)obj);
        return Objects.equals(this.identityStoreId(), other.identityStoreId()) && Objects.equals(this.memberId(), other.memberId()) && this.hasGroupIds() == other.hasGroupIds() && Objects.equals(this.groupIds(), other.groupIds());
    }

    public final String toString() {
        return ToString.builder((String)"IsMemberInGroupsRequest").add("IdentityStoreId", (Object)this.identityStoreId()).add("MemberId", (Object)this.memberId()).add("GroupIds", this.hasGroupIds() ? this.groupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "GroupIds": {
                return Optional.ofNullable(clazz.cast(this.groupIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IsMemberInGroupsRequest, T> g) {
        return obj -> g.apply((IsMemberInGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IdentitystoreRequest.BuilderImpl
    implements Builder {
        private String identityStoreId;
        private MemberId memberId;
        private List<String> groupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IsMemberInGroupsRequest model) {
            super(model);
            this.identityStoreId(model.identityStoreId);
            this.memberId(model.memberId);
            this.groupIds(model.groupIds);
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final MemberId.Builder getMemberId() {
            return this.memberId != null ? this.memberId.toBuilder() : null;
        }

        public final void setMemberId(MemberId.BuilderImpl memberId) {
            this.memberId = memberId != null ? memberId.build() : null;
        }

        @Override
        public final Builder memberId(MemberId memberId) {
            this.memberId = memberId;
            return this;
        }

        public final Collection<String> getGroupIds() {
            if (this.groupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupIds;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdsCopier.copy(groupIds);
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdsCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String ... groupIds) {
            this.groupIds(Arrays.asList(groupIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IsMemberInGroupsRequest build() {
            return new IsMemberInGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IdentitystoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, IsMemberInGroupsRequest> {
        public Builder identityStoreId(String var1);

        public Builder memberId(MemberId var1);

        default public Builder memberId(Consumer<MemberId.Builder> memberId) {
            return this.memberId((MemberId)((MemberId.Builder)MemberId.builder().applyMutation(memberId)).build());
        }

        public Builder groupIds(Collection<String> var1);

        public Builder groupIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

