/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.identitystore.model.AlternateIdentifier;
import software.amazon.awssdk.services.identitystore.model.IdentitystoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGroupIdRequest
extends IdentitystoreRequest
implements ToCopyableBuilder<Builder, GetGroupIdRequest> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityStoreId").getter(GetGroupIdRequest.getter(GetGroupIdRequest::identityStoreId)).setter(GetGroupIdRequest.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()}).build();
    private static final SdkField<AlternateIdentifier> ALTERNATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlternateIdentifier").getter(GetGroupIdRequest.getter(GetGroupIdRequest::alternateIdentifier)).setter(GetGroupIdRequest.setter(Builder::alternateIdentifier)).constructor(AlternateIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD, ALTERNATE_IDENTIFIER_FIELD));
    private final String identityStoreId;
    private final AlternateIdentifier alternateIdentifier;

    private GetGroupIdRequest(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.alternateIdentifier = builder.alternateIdentifier;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public final AlternateIdentifier alternateIdentifier() {
        return this.alternateIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternateIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupIdRequest)) {
            return false;
        }
        GetGroupIdRequest other = (GetGroupIdRequest)((Object)obj);
        return Objects.equals(this.identityStoreId(), other.identityStoreId()) && Objects.equals(this.alternateIdentifier(), other.alternateIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetGroupIdRequest").add("IdentityStoreId", (Object)this.identityStoreId()).add("AlternateIdentifier", (Object)this.alternateIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
            case "AlternateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.alternateIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupIdRequest, T> g) {
        return obj -> g.apply((GetGroupIdRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IdentitystoreRequest.BuilderImpl
    implements Builder {
        private String identityStoreId;
        private AlternateIdentifier alternateIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupIdRequest model) {
            super(model);
            this.identityStoreId(model.identityStoreId);
            this.alternateIdentifier(model.alternateIdentifier);
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final AlternateIdentifier.Builder getAlternateIdentifier() {
            return this.alternateIdentifier != null ? this.alternateIdentifier.toBuilder() : null;
        }

        public final void setAlternateIdentifier(AlternateIdentifier.BuilderImpl alternateIdentifier) {
            this.alternateIdentifier = alternateIdentifier != null ? alternateIdentifier.build() : null;
        }

        @Override
        public final Builder alternateIdentifier(AlternateIdentifier alternateIdentifier) {
            this.alternateIdentifier = alternateIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGroupIdRequest build() {
            return new GetGroupIdRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IdentitystoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGroupIdRequest> {
        public Builder identityStoreId(String var1);

        public Builder alternateIdentifier(AlternateIdentifier var1);

        default public Builder alternateIdentifier(Consumer<AlternateIdentifier.Builder> alternateIdentifier) {
            return this.alternateIdentifier((AlternateIdentifier)((AlternateIdentifier.Builder)AlternateIdentifier.builder().applyMutation(alternateIdentifier)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

